/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.tree;

import com.metamatrix.common.tree.TreeNode;
import com.metamatrix.common.tree.TreeNodeIterator;
import com.metamatrix.common.tree.TreeView;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class TreeNodeIteratorWithStack
implements Iterator {
    private final Iterator iterator;
    private final LinkedList workingList;
    private final LinkedList stack;
    private final TreeView view;
    private final TreeNode startingNode;

    public TreeNodeIteratorWithStack(TreeNode startingNode, TreeView view) {
        this(startingNode, view, new TreeNodeIterator(startingNode, view));
    }

    public TreeNodeIteratorWithStack(TreeNode startingNode, TreeView view, Iterator iter) {
        this.iterator = iter;
        this.view = view;
        this.workingList = new LinkedList();
        this.stack = new LinkedList();
        this.startingNode = startingNode;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public void remove() {
        this.iterator.remove();
    }

    public Object next() {
        Object nextObj = this.iterator.next();
        this.process(nextObj);
        return nextObj;
    }

    protected void process(Object object) {
        this.synchronizeStack((TreeNode)object);
    }

    protected void synchronizeStack(TreeNode obj) {
        this.workingList.clear();
        TreeNode node = obj;
        while (node != null) {
            this.workingList.add(0, node);
            if (this.isStartingNode(node)) {
                node = null;
                continue;
            }
            node = this.view.getParent(node);
        }
        TreeNode objAncestor = null;
        ListIterator workingIter = this.workingList.listIterator();
        ListIterator stackIter = this.stack.listIterator();
        while (workingIter.hasNext() && stackIter.hasNext()) {
            objAncestor = (TreeNode)workingIter.next();
            StackEntry entry = (StackEntry)stackIter.next();
            if (entry.getTreeNode() == objAncestor) continue;
            while (this.stack.removeLast() != entry) {
            }
            workingIter.previous();
            break;
        }
        while (workingIter.hasNext()) {
            objAncestor = (TreeNode)workingIter.next();
            Object payload = this.createPayload(objAncestor);
            StackEntry entry = new StackEntry(objAncestor, payload);
            this.stack.add(entry);
        }
    }

    protected boolean isStartingNode(TreeNode node) {
        if (this.startingNode != null) {
            return this.startingNode == node;
        }
        if (this.iterator instanceof TreeNodeIterator) {
            return ((TreeNodeIterator)this.iterator).isStartingNode(node);
        }
        return false;
    }

    protected Object createPayload(TreeNode node) {
        return null;
    }

    public LinkedList getStack() {
        return this.stack;
    }

    public TreeView getTreeView() {
        return this.view;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        int counter = 0;
        Iterator iter = this.getStack().iterator();
        while (iter.hasNext()) {
            StackEntry entry = (StackEntry)iter.next();
            sb.append("  ");
            sb.append(++counter);
            sb.append(". ");
            sb.append(entry.getTreeNode().getName());
            Object payload = entry.getPayload();
            if (payload != null) {
                sb.append(this.toStringPayload(payload));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    protected String toStringPayload(Object obj) {
        return "";
    }

    public static class StackEntry {
        private final TreeNode target;
        private final Object payload;

        protected StackEntry(TreeNode target, Object payload) {
            this.target = target;
            this.payload = payload;
        }

        public TreeNode getTreeNode() {
            return this.target;
        }

        public Object getPayload() {
            return this.payload;
        }

        public String toString() {
            return ((Object)this.target).toString();
        }
    }
}

