/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.impl.statistics;

import com.metamatrix.common.pooling.impl.BasicPoolStatistic;

public class AvgStat
extends BasicPoolStatistic {
    private long cnt = 0L;
    private long sumValue = 0L;

    public AvgStat(String statName, String displayName, String description, int aggregateType) {
        super(statName, displayName, description, aggregateType);
    }

    public void increment(long value) {
        this.sumValue += value;
        ++this.cnt;
    }

    public synchronized Object getValue() {
        if (this.cnt > 0L) {
            double avg = this.sumValue / this.cnt;
            return new Double(avg);
        }
        return new Double(0.0);
    }

    public synchronized void reset() {
        this.cnt = 0L;
        this.sumValue = 0L;
    }
}

