/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.api;

import java.io.Serializable;

public final class ResourceStatistics
implements Serializable {
    private int concurrentUsers = 0;
    private long lastUsed;
    private String userName = "";
    private long creationTime = System.currentTimeMillis();

    public synchronized int getConcurrentUserCount() {
        return this.concurrentUsers;
    }

    public synchronized boolean hasConcurrentUsers() {
        return this.concurrentUsers > 0;
    }

    public synchronized void addConcurrentUser(String userName) {
        ++this.concurrentUsers;
        this.markAsUsed();
        this.userName = userName;
    }

    public synchronized void removeConcurrentUser(String userName) {
        this.userName = "";
        if (this.concurrentUsers > 0) {
            --this.concurrentUsers;
        }
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public synchronized long getLastUsed() {
        return this.lastUsed;
    }

    public synchronized void markAsUsed() {
        this.lastUsed = System.currentTimeMillis();
    }

    public String getUserName() {
        return this.userName;
    }
}

