/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.pooling.api;

import java.util.HashMap;
import java.util.Map;

public final class ResourcePoolStatisticNames {
    public static final String TOTAL_PHYSICAL_RESOURCES_USED = "totalPhysicalResourcesUsed";
    public static final String NUM_OF_TIMEOUTS = "numOfTimeouts";
    public static final String NUM_OF_RESOURCES_REQUESTED = "resourcesRequested";
    public static final String NUM_OF_SUCCESSFUL_REQUESTS = "successfulRequests";
    public static final String NUM_OF_UNSUCCESSFUL_REQUESTS = "unsuccessfulRequests";
    public static final String MAX_NUM_OF_RESOURCES_IN_POOL = "maxNumInPool";
    public static final String NUM_OF_RESOURCES_IN_POOL = "numInPool";
    public static final String MAX_RESOURCE_SIZE = "maxResourceLimit";
    public static final String MIN_RESOURCE_SIZE = "minResourceLimit";
    private static Map displayNames = null;
    private static Map descriptions = null;
    private static final int num_of_stats = 7;

    public static final String getDisplayName(String statisticName) {
        return (String)displayNames.get(statisticName);
    }

    public static final String getDescription(String statisticName) {
        return (String)descriptions.get(statisticName);
    }

    static {
        displayNames = new HashMap(7);
        displayNames.put(NUM_OF_RESOURCES_REQUESTED, "Total Requests");
        displayNames.put(NUM_OF_SUCCESSFUL_REQUESTS, "Successful Requests");
        displayNames.put(NUM_OF_UNSUCCESSFUL_REQUESTS, "Failed Requests");
        displayNames.put(TOTAL_PHYSICAL_RESOURCES_USED, "Connections Created");
        displayNames.put(NUM_OF_TIMEOUTS, "Timeouts");
        displayNames.put(MAX_NUM_OF_RESOURCES_IN_POOL, "Pool Watermark");
        displayNames.put(NUM_OF_RESOURCES_IN_POOL, "Connections in Pool");
        descriptions = new HashMap(7);
        descriptions.put(NUM_OF_RESOURCES_REQUESTED, "The number of times a connection was requested");
        descriptions.put(NUM_OF_SUCCESSFUL_REQUESTS, "The number of times a connection was successfully requested");
        descriptions.put(NUM_OF_UNSUCCESSFUL_REQUESTS, "The number of times a connection request failed");
        descriptions.put(TOTAL_PHYSICAL_RESOURCES_USED, "The number of times a connection was created");
        descriptions.put(NUM_OF_TIMEOUTS, "The number of times a request timed out waiting for a connection");
        descriptions.put(MAX_NUM_OF_RESOURCES_IN_POOL, "The highest number of connections ever in the pool");
        descriptions.put(NUM_OF_RESOURCES_IN_POOL, "The number of connections currently in the pool");
    }

    private static interface Descriptions {
        public static final String TOTAL_PHYSICAL_RESOURCES_USED = "The number of times a connection was created";
        public static final String NUM_OF_TIMEOUTS = "The number of times a request timed out waiting for a connection";
        public static final String NUM_OF_RESOURCES_REQUESTED = "The number of times a connection was requested";
        public static final String NUM_OF_SUCCESSFUL_REQUESTS = "The number of times a connection was successfully requested";
        public static final String NUM_OF_UNSUCCESSFUL_REQUESTS = "The number of times a connection request failed";
        public static final String MAX_NUM_OF_RESOURCES_IN_POOL = "The highest number of connections ever in the pool";
        public static final String NUM_OF_RESOURCES_IN_POOL = "The number of connections currently in the pool";
    }

    private static interface DisplayNames {
        public static final String TOTAL_PHYSICAL_RESOURCES_USED = "Connections Created";
        public static final String NUM_OF_TIMEOUTS = "Timeouts";
        public static final String NUM_OF_RESOURCES_REQUESTED = "Total Requests";
        public static final String NUM_OF_SUCCESSFUL_REQUESTS = "Successful Requests";
        public static final String NUM_OF_UNSUCCESSFUL_REQUESTS = "Failed Requests";
        public static final String MAX_NUM_OF_RESOURCES_IN_POOL = "Pool Watermark";
        public static final String NUM_OF_RESOURCES_IN_POOL = "Connections in Pool";
    }
}

