/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.object;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.object.ObjectDefinition;
import com.metamatrix.common.util.exception.AssertionException;
import com.metamatrix.core.util.StringUtil;
import java.io.Serializable;

public class ObjectDefinitionImpl
implements Serializable,
Comparable,
Cloneable,
ObjectDefinition {
    private String name = "";
    private String pluralDisplayName = "";
    private String shortDisplayName = "";
    private String displayName = "";
    private String shortDescription = "";

    public ObjectDefinitionImpl() {
    }

    public ObjectDefinitionImpl(String name) {
        this.setName(name);
        this.setDisplayName(name);
    }

    public ObjectDefinitionImpl(String name, String displayName) {
        this.setName(name);
        this.setDisplayName(displayName);
    }

    public ObjectDefinitionImpl(ObjectDefinition defn) {
        if (defn == null) {
            throw new AssertionException("ERR.003.019.0014", CommonPlugin.Util.getString("ERR.003.019.0014"));
        }
        this.setName(defn.getName());
        this.setDisplayName(defn.getDisplayName());
        this.setShortDisplayName(defn.getShortDisplayName());
        this.setPluralDisplayName(defn.getPluralDisplayName());
        this.setShortDescription(defn.getShortDescription());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name != null ? name : "";
    }

    public String getPluralDisplayName() {
        return this.pluralDisplayName;
    }

    public void setPluralDisplayName(String displayName) {
        this.pluralDisplayName = displayName != null ? displayName : this.displayName + "s";
    }

    public String getShortDisplayName() {
        return this.shortDisplayName;
    }

    public void setShortDisplayName(String displayName) {
        this.shortDisplayName = displayName != null ? displayName : this.displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName != null ? displayName : this.name;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription != null ? shortDescription : "";
    }

    public int compareTo(Object obj) {
        ObjectDefinitionImpl that = (ObjectDefinitionImpl)obj;
        if (obj == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.019.0007", this.getClass().getName()));
        }
        return this.name.compareTo(that.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass().isInstance(obj)) {
            ObjectDefinitionImpl that = (ObjectDefinitionImpl)obj;
            return this.getName().equals(that.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.displayName;
    }

    public Object clone() {
        return new ObjectDefinitionImpl(this);
    }

    public void computeDisplayName() {
        String result = StringUtil.computeDisplayableForm(this.getName(), null);
        if (result != null) {
            this.setDisplayName(result);
        }
    }

    public void computePluralDisplayName() {
        String result;
        String displayName = this.getDisplayName();
        if (displayName == null || displayName.length() == 0) {
            displayName = StringUtil.computeDisplayableForm(this.getName(), null);
        }
        if (displayName != null && (result = StringUtil.computePluralForm(displayName, null)) != null) {
            this.setPluralDisplayName(result);
        }
    }
}

