/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.log.config;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.log.LogConfiguration;
import com.metamatrix.common.log.MessageLevel;
import com.metamatrix.common.log.config.LogConfigurationException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class BasicLogConfiguration
implements LogConfiguration,
Serializable {
    public static final String LOG_LEVEL_PROPERTY_NAME = "metamatrix.log";
    public static final String LOG_CONTEXT_PROPERTY_NAME = "metamatrix.log.contexts";
    public static final String CONTEXT_DELIMETER = ",";
    private Set discardedContexts = null;
    private Set unmodifiableContexts = null;
    private int msgLevel;

    public static LogConfiguration createLogConfiguration(Properties props) throws LogConfigurationException {
        String contextValues;
        if (props == null) {
            return new BasicLogConfiguration();
        }
        BasicLogConfiguration result = null;
        String logValue = props.getProperty(LOG_LEVEL_PROPERTY_NAME);
        if (logValue != null && logValue.trim().length() > 0) {
            try {
                int logLevel = Integer.parseInt(logValue);
                result = new BasicLogConfiguration(logLevel);
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        if (result == null) {
            result = new BasicLogConfiguration();
        }
        if ((contextValues = props.getProperty(LOG_CONTEXT_PROPERTY_NAME)) != null) {
            StringTokenizer tokenizer = new StringTokenizer(contextValues, CONTEXT_DELIMETER);
            while (tokenizer.hasMoreElements()) {
                result.discardContext(tokenizer.nextElement().toString());
            }
        }
        return result;
    }

    public static Properties getLogConfigurationProperties(LogConfiguration logConfiguration) throws LogConfigurationException {
        if (logConfiguration == null) {
            return new Properties();
        }
        String logLevel = String.valueOf(logConfiguration.getMessageLevel());
        String contextString = null;
        Set discards = logConfiguration.getDiscardedContexts();
        if (discards.size() != 0) {
            StringBuffer contextValues = new StringBuffer();
            Iterator discardedContexts = logConfiguration.getDiscardedContexts().iterator();
            while (discardedContexts.hasNext()) {
                if (contextValues.length() != 0) {
                    contextValues.append(CONTEXT_DELIMETER);
                }
                contextValues.append((String)discardedContexts.next());
            }
            contextString = contextValues.toString();
        }
        Properties props = new Properties();
        if (logLevel != null) {
            props.setProperty(LOG_LEVEL_PROPERTY_NAME, logLevel);
        }
        if (contextString != null) {
            props.setProperty(LOG_CONTEXT_PROPERTY_NAME, contextString);
        }
        return props;
    }

    public BasicLogConfiguration(Collection contexts, int msgLevel) {
        if (!MessageLevel.isMessageLevelValid(msgLevel)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.014.0014", new Object[]{String.valueOf(msgLevel), String.valueOf(MessageLevel.getValidLowerMessageLevel()), String.valueOf(MessageLevel.getValidUpperMessageLevel())}));
        }
        this.msgLevel = msgLevel;
        this.discardedContexts = contexts != null ? new HashSet(contexts) : new HashSet();
        this.unmodifiableContexts = Collections.unmodifiableSet(this.discardedContexts);
    }

    public BasicLogConfiguration() {
        this.msgLevel = 3;
        this.discardedContexts = new HashSet();
        this.unmodifiableContexts = Collections.unmodifiableSet(this.discardedContexts);
    }

    public BasicLogConfiguration(int msgLevel) {
        this(null, msgLevel);
    }

    public BasicLogConfiguration(LogConfiguration currentLogConfig) {
        this.msgLevel = currentLogConfig.getMessageLevel();
        this.discardedContexts = new HashSet(currentLogConfig.getDiscardedContexts());
        this.unmodifiableContexts = Collections.unmodifiableSet(this.discardedContexts);
    }

    public boolean isContextDiscarded(String context) {
        boolean discarded = context != null && this.discardedContexts.contains(context);
        return discarded;
    }

    public boolean isLevelDiscarded(int level) {
        return level > this.msgLevel;
    }

    public Set getDiscardedContexts() {
        return this.unmodifiableContexts;
    }

    public void discardContext(String context) {
        if (context != null) {
            this.discardedContexts.add(context);
        }
        this.unmodifiableContexts = Collections.unmodifiableSet(this.discardedContexts);
    }

    public int getMessageLevel() {
        return this.msgLevel;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.000.0001", "LogConfiguration"));
        }
        LogConfiguration that = (LogConfiguration)obj;
        int diff = this.getMessageLevel() - that.getMessageLevel();
        if (diff != 0) {
            return diff;
        }
        boolean sizesMatch = this.getDiscardedContexts().size() == that.getDiscardedContexts().size();
        boolean thisContainsThat = this.getDiscardedContexts().containsAll(that.getDiscardedContexts());
        if (thisContainsThat) {
            if (sizesMatch) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LogConfiguration) {
            LogConfiguration that = (LogConfiguration)obj;
            int diff = this.getMessageLevel() - that.getMessageLevel();
            if (diff != 0) {
                return false;
            }
            boolean sizesMatch = this.getDiscardedContexts().size() == that.getDiscardedContexts().size();
            boolean thisContainsThat = this.getDiscardedContexts().containsAll(that.getDiscardedContexts());
            if (thisContainsThat && sizesMatch) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer str = new StringBuffer("LogConfiguration: {");
        str.append("Log Level: " + MessageLevel.getLabelForLevel(this.msgLevel));
        str.append("; DiscardedContexts[");
        Iterator iter = this.discardedContexts.iterator();
        if (iter.hasNext()) {
            str.append(iter.next().toString());
        }
        while (iter.hasNext()) {
            str.append(',');
            str.append(iter.next().toString());
        }
        str.append("]}");
        return str.toString();
    }

    public Object clone() {
        return new BasicLogConfiguration(this.discardedContexts, this.msgLevel);
    }

    public void recordAllContexts() {
    }

    public void discardContexts(Collection contexts) {
        Iterator it = contexts.iterator();
        while (it.hasNext()) {
            String c2 = (String)it.next();
            if (this.discardedContexts.contains(c2)) continue;
            this.discardedContexts.add(c2);
        }
        this.unmodifiableContexts = Collections.unmodifiableSet(this.discardedContexts);
    }

    public void recordContexts(Collection contexts) {
        Iterator it = contexts.iterator();
        while (it.hasNext()) {
            String c2 = (String)it.next();
            if (!this.discardedContexts.contains(c2)) continue;
            this.discardedContexts.remove(c2);
        }
        this.unmodifiableContexts = Collections.unmodifiableSet(this.discardedContexts);
    }

    public void setMessageLevel(int level) {
        this.msgLevel = level;
    }
}

