/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jndi;

import com.metamatrix.common.jndi.JNDIRegistry;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class MMContext
implements Context {
    public void bind(String name, Object obj) throws NamingException {
        if (JNDIRegistry.getInstance().contains(name)) {
            throw new NameAlreadyBoundException("Name already exists: " + name);
        }
        this.rebind(name, obj);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot bind empty name");
        }
        if (obj instanceof Remote) {
            try {
                obj = UnicastRemoteObject.toStub((Remote)obj);
                System.out.println("Binding remote object: " + obj.getClass().getName());
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new NamingException("Error binding remote object");
            }
        }
        JNDIRegistry.getInstance().bind(name, obj);
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public Object lookup(String name) throws NamingException {
        if (name.equals("")) {
            return this;
        }
        return JNDIRegistry.getInstance().lookup(name);
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public void unbind(String name) throws NamingException {
        if (name.equals("")) {
            throw new InvalidNameException("Cannot unbind empty name");
        }
        JNDIRegistry.getInstance().unbind(name);
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void close() throws NamingException {
    }

    public Object addToEnvironment(String arg0, Object arg1) throws NamingException {
        throw new OperationNotSupportedException("addToEvironment is not supported.");
    }

    public String composeName(String arg0, String arg1) throws NamingException {
        throw new OperationNotSupportedException("composeName is not supported.");
    }

    public Name composeName(Name arg0, Name arg1) throws NamingException {
        throw new OperationNotSupportedException("composeName is not supported.");
    }

    public Context createSubcontext(String arg0) throws NamingException {
        throw new OperationNotSupportedException("createSubcontext is not supported.");
    }

    public Context createSubcontext(Name arg0) throws NamingException {
        throw new OperationNotSupportedException("createSubcontext is not supported.");
    }

    public void destroySubcontext(String arg0) throws NamingException {
        throw new OperationNotSupportedException("destroySubcontext is not supported.");
    }

    public void destroySubcontext(Name arg0) throws NamingException {
        throw new OperationNotSupportedException("destroySubcontext is not supported.");
    }

    public Hashtable getEnvironment() throws NamingException {
        throw new OperationNotSupportedException("destroySubcontext is not supported.");
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("getNameInNamespace is not supported.");
    }

    public NameParser getNameParser(String arg0) throws NamingException {
        throw new OperationNotSupportedException("getNameParser is not supported.");
    }

    public NameParser getNameParser(Name arg0) throws NamingException {
        throw new OperationNotSupportedException("getNameParser is not supported.");
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (name.equals("")) {
            return new MMNames(JNDIRegistry.getInstance().getAllNames());
        }
        return new MMNames(new Hashtable().keys());
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (name.equals("")) {
            return new MMBindings(JNDIRegistry.getInstance().getAllNames());
        }
        return new MMBindings(new Hashtable().keys());
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public Object lookupLink(String arg0) throws NamingException {
        throw new OperationNotSupportedException("lookupLink is not supported.");
    }

    public Object lookupLink(Name arg0) throws NamingException {
        throw new OperationNotSupportedException("lookupLink is not supported.");
    }

    public Object removeFromEnvironment(String arg0) throws NamingException {
        throw new OperationNotSupportedException("removeFromEnvironment is not supported.");
    }

    public void rename(String arg0, String arg1) throws NamingException {
        throw new OperationNotSupportedException("removeFromEnvironment is not supported.");
    }

    public void rename(Name arg0, Name arg1) throws NamingException {
        throw new OperationNotSupportedException("rename is not supported.");
    }

    static class MMBindings
    implements NamingEnumeration {
        Enumeration names;

        MMBindings(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            return new Binding(name, JNDIRegistry.getInstance().lookup(name));
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() {
        }

        public String toString() {
            String s2 = "";
            while (this.hasMoreElements()) {
                s2 = s2 + this.nextElement().toString() + "\n";
            }
            return s2;
        }
    }

    static class MMNames
    implements NamingEnumeration {
        Enumeration names;

        MMNames(Enumeration names) {
            this.names = names;
        }

        public boolean hasMoreElements() {
            return this.names.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object nextElement() {
            String name = (String)this.names.nextElement();
            String className = JNDIRegistry.getInstance().lookup(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public void close() {
        }

        public String toString() {
            String s2 = "";
            while (this.hasMoreElements()) {
                s2 = s2 + this.nextElement().toString() + "\n";
            }
            return s2;
        }
    }
}

