/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc.metadata;

import com.metamatrix.common.CommonPlugin;
import java.util.HashMap;
import java.util.Map;

public class Nullability {
    public static final Nullability NO_NULLS = new Nullability(0, "No Nulls");
    public static final Nullability NULLABLE = new Nullability(1, "Nullable");
    public static final Nullability UNKNOWN = new Nullability(2, "Unknown");
    public static final Nullability PROCEDURE_NO_NULLS = new Nullability(0, "No Nulls");
    public static final Nullability PROCEDURE_NULLABLE = new Nullability(1, "Nullable");
    public static final Nullability PROCEDURE_NULLABLE_UNKNOWN = new Nullability(2, "Unknown");
    private int value;
    private String displayName;
    private static Map BY_NAME;
    private static Map BY_VALUE;

    private Nullability(int value, String displayName) {
        this.value = value;
        this.displayName = displayName;
        Nullability.add(this);
    }

    private static void add(Nullability instance) {
        if (BY_NAME == null) {
            BY_NAME = new HashMap();
        }
        if (BY_VALUE == null) {
            BY_VALUE = new HashMap();
        }
        BY_NAME.put(instance.getDisplayName(), instance);
        BY_VALUE.put(new Integer(instance.value), instance);
    }

    public static Nullability getInstance(String displayName) {
        return (Nullability)BY_NAME.get(displayName);
    }

    public static Nullability getInstance(int value) {
        return (Nullability)BY_VALUE.get(new Integer(value));
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int compareTo(Object obj) {
        Nullability that = (Nullability)obj;
        if (obj == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.015.0022"));
        }
        return this.value - that.value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Nullability) {
            Nullability that = (Nullability)obj;
            return this.value == that.value;
        }
        return false;
    }

    public final int hashCode() {
        return this.value;
    }

    public final String toString() {
        return this.getDisplayName();
    }
}

