/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.jdbc;

import com.ddtek.jdbc.extensions.ExtEmbeddedConnection;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import java.sql.Connection;
import java.sql.Date;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.StringCharacterIterator;
import java.util.Properties;

public class JDBCUtil {
    public static final String DRIVER = "com.metamatrix.common.util.JDBCUtil.Driver";
    public static final String PROTOCOL = "com.metamatrix.common.util.JDBCUtil.Protocol";
    public static final String DATABASE = "com.metamatrix.common.util.JDBCUtil.Database";
    public static final String USERNAME = "com.metamatrix.common.util.JDBCUtil.User";
    public static final String PASSWORD = "com.metamatrix.common.util.JDBCUtil.Password";
    private static final String JDBC_PREFIX = "jdbc:";
    private static final String DRIVER_PWD_PROP_NAME = "password";
    private static final String DRIVER_USER_PROP_NAME = "user";
    private static final String OEM_ID = "mm";

    public static Connection decryptAndCreateJDBCConnection(Properties env) throws MetaMatrixException, SQLException {
        Properties jdbcEnv;
        try {
            jdbcEnv = CryptoUtil.propertyDecrypt(PASSWORD, env);
        }
        catch (CryptoException e2) {
            throw new MetaMatrixException((Throwable)e2, "ERR.003.030.0175", CommonPlugin.Util.getString("ERR.003.030.0175"));
        }
        return JDBCUtil.createJDBCConnection(jdbcEnv);
    }

    public static Connection createJDBCConnection(Properties env) throws MetaMatrixException, SQLException {
        Connection connection = null;
        String driverClassName = env.getProperty(DRIVER);
        String protocol = env.getProperty(PROTOCOL);
        String database = env.getProperty(DATABASE);
        String username = env.getProperty(USERNAME);
        String password = env.getProperty(PASSWORD, "");
        if (driverClassName == null || driverClassName.trim().length() == 0) {
            throw new MetaMatrixException("ERR.003.030.0176", CommonPlugin.Util.getString("ERR.003.030.0176"));
        }
        if (database == null || database.trim().length() == 0) {
            throw new MetaMatrixException("ERR.003.030.0178", CommonPlugin.Util.getString("ERR.003.030.0178"));
        }
        String url = null;
        if (database.startsWith(JDBC_PREFIX) && (protocol == null || protocol.trim().length() == 0)) {
            url = database;
        } else {
            if (protocol == null || protocol.trim().length() == 0) {
                throw new MetaMatrixException("ERR.003.030.0177", CommonPlugin.Util.getString("ERR.003.030.0177"));
            }
            url = JDBCUtil.getDatabaseURL(env);
        }
        Properties props = new Properties();
        if (username != null && username.trim().length() > 0) {
            props.setProperty(DRIVER_USER_PROP_NAME, username.trim());
            props.setProperty(DRIVER_PWD_PROP_NAME, password.trim());
        }
        try {
            Driver driver = null;
            try {
                driver = (Driver)Class.forName(driverClassName).newInstance();
            }
            catch (Exception e2) {
                throw new MetaMatrixException((Throwable)e2, "ERR.003.030.0179", CommonPlugin.Util.getString("ERR.003.030.0179", driverClassName));
            }
            if (!driver.acceptsURL(url)) {
                throw new MetaMatrixException("ERR.003.030.0180", CommonPlugin.Util.getString("ERR.003.030.0180", driverClassName, url));
            }
            connection = driver.connect(url, props);
            if (connection instanceof ExtEmbeddedConnection) {
                ((ExtEmbeddedConnection)connection).unlock(OEM_ID);
            }
        }
        catch (Exception e3) {
            throw new MetaMatrixException((Throwable)e3, "ERR.003.030.0181", CommonPlugin.Util.getString("ERR.003.030.0181", url));
        }
        return connection;
    }

    public static String getDatabaseURL(Properties env) {
        return JDBC_PREFIX + env.getProperty(PROTOCOL) + ":" + env.getProperty(DATABASE);
    }

    public static String getDatabaseURL(String protocol, String database) {
        return JDBC_PREFIX + protocol + ":" + database;
    }

    public static void addAsLiteral(StringBuffer sb, Object value) {
        if (value == null) {
            sb.append("NULL");
        } else if (value instanceof Number) {
            JDBCUtil.addAsLiteral(sb, (Number)value);
        } else if (value instanceof Boolean) {
            JDBCUtil.addAsLiteral(sb, (Boolean)value);
        } else if (value instanceof Timestamp) {
            JDBCUtil.addAsLiteral(sb, (Timestamp)value);
        } else if (value instanceof Time) {
            JDBCUtil.addAsLiteral(sb, (Time)value);
        } else if (value instanceof Date) {
            JDBCUtil.addAsLiteral(sb, (Date)value);
        } else {
            JDBCUtil.addAsLiteral(sb, value.toString());
        }
    }

    public static void addAsLiteral(StringBuffer sb, String value) {
        if (value == null) {
            sb.append("NULL");
        } else {
            sb.append('\'');
            StringCharacterIterator iter = new StringCharacterIterator(value);
            char c2 = iter.first();
            while (c2 != '\uffff') {
                if (c2 == '\'') {
                    sb.append('\'');
                }
                sb.append(c2);
                c2 = iter.next();
            }
            sb.append('\'');
        }
    }

    public static void addAsLiteral(StringBuffer sb, String value, int maxColumnLength) {
        if (maxColumnLength < 0 || value == null) {
            sb.append("NULL");
        } else {
            sb.append('\'');
            String text = value;
            if (maxColumnLength != 0 && text.length() > maxColumnLength) {
                text = text.substring(0, maxColumnLength);
            }
            StringCharacterIterator iter = new StringCharacterIterator(text);
            char c2 = iter.first();
            while (c2 != '\uffff') {
                if (c2 == '\'') {
                    sb.append('\'');
                }
                sb.append(c2);
                c2 = iter.next();
            }
            sb.append('\'');
        }
    }

    public static void addAsLiteral(StringBuffer sb, Number number) {
        if (number == null) {
            sb.append("NULL");
        } else {
            sb.append(number.toString());
        }
    }

    public static void addAsLiteral(StringBuffer sb, Boolean value) {
        if (value == null) {
            sb.append("NULL");
        } else {
            JDBCUtil.addAsLiteral(sb, (boolean)value);
        }
    }

    public static void addAsLiteral(StringBuffer sb, Time value) {
        if (value == null) {
            sb.append("NULL");
        } else {
            sb.append("{");
            sb.append("t ");
            sb.append("'");
            sb.append(value.toString());
            sb.append("'");
            sb.append("}");
        }
    }

    public static void addAsLiteral(StringBuffer sb, Timestamp value) {
        if (value == null) {
            sb.append("NULL");
        } else {
            sb.append("{");
            sb.append("ts ");
            sb.append("'");
            sb.append(value.toString());
            sb.append("'");
            sb.append("}");
        }
    }

    public static void addAsLiteral(StringBuffer sb, Date value) {
        if (value == null) {
            sb.append("NULL");
        } else {
            sb.append("{");
            sb.append("d ");
            sb.append("'");
            sb.append(value.toString());
            sb.append("'");
            sb.append("}");
        }
    }

    public static void addAsLiteral(StringBuffer sb, boolean value) {
        sb.append('\'');
        sb.append(value ? (char)'1' : '0');
        sb.append('\'');
    }

    public static void addAsLikeLiteral(StringBuffer sb, String value, char escapeCharacter) {
        JDBCUtil.addAsLiteral(sb, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        Properties env = new Properties();
        env.setProperty(DRIVER, "weblogic.jdbc.mssqlserver4.Driver");
        env.setProperty(PROTOCOL, "weblogic:mssqlserver4");
        env.setProperty(DATABASE, "Metadata@slnt1dv02");
        env.setProperty(USERNAME, "metadatauser");
        env.setProperty(PASSWORD, "metadatauser");
        Connection connection = null;
        System.out.print("Attempting to connect to database \"" + JDBCUtil.getDatabaseURL(env) + "\" ...");
        connection = JDBCUtil.createJDBCConnection(env);
        System.out.print(" completed\n");
        Object var5_3 = null;
        if (connection == null) return;
        try {
            System.out.print("Closing connection to database ...");
            connection.close();
            System.out.print(" completed\n");
            return;
        }
        catch (Exception e22) {
            e22.printStackTrace();
        }
        return;
        {
            catch (Exception e2) {
                e2.printStackTrace();
                Object var5_4 = null;
                if (connection == null) return;
                try {
                    System.out.print("Closing connection to database ...");
                    connection.close();
                    System.out.print(" completed\n");
                    return;
                }
                catch (Exception e22) {
                    e22.printStackTrace();
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (connection == null) throw throwable;
            try {
                System.out.print("Closing connection to database ...");
                connection.close();
                System.out.print(" completed\n");
                throw throwable;
            }
            catch (Exception e22) {
                e22.printStackTrace();
            }
            throw throwable;
        }
    }
}

