/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.id.dbid;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.id.dbid.DBIDController;
import com.metamatrix.common.id.dbid.DBIDGeneratorException;
import com.metamatrix.common.id.dbid.spi.InMemoryIDController;
import com.metamatrix.common.id.dbid.spi.PersistentIDController;

public class DBIDGenerator {
    public static final String VM_ID = "VM";
    public static final String SERVICE_ID = "Service";
    public static final String REQUEST_ID = "Request";
    public static final String CONNECTOR_PROCESSOR_ID = "Connector_Processor";
    public static final String SESSION_ID = "Session";
    public static final String TRANSACTION_ID = "Transaction";
    public static final String TUPLE_SOURCE_ID = "TupleSource";
    public static final String RESOURCE_POOL_MGR_ID = "ResourcePoolMgr";
    private static DBIDGenerator generator;
    private static DBIDController controller;
    private static boolean usePersistenceIDGeneration;

    private DBIDGenerator() throws Exception {
        controller = usePersistenceIDGeneration ? new PersistentIDController() : new InMemoryIDController();
    }

    public static long getID(String context, boolean enableRollOver) throws DBIDGeneratorException {
        try {
            return DBIDGenerator.getInstance().getUniqueID(context, enableRollOver);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new DBIDGeneratorException(e2, "Error creating id for " + context + " context.");
        }
    }

    public static long getID(String context) throws DBIDGeneratorException {
        try {
            return DBIDGenerator.getInstance().getUniqueID(context, false);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new DBIDGeneratorException(e2, "ERR.003.013.0011", CommonPlugin.Util.getString("ERR.003.013.0011", context));
        }
    }

    public static void setCacheBlockSize(String context, long cache) throws DBIDGeneratorException {
        try {
            DBIDGenerator.getInstance().setContextBlockSize(context, cache);
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new DBIDGeneratorException(e2, "ERR.003.013.0012", CommonPlugin.Util.getString("ERR.003.013.0012", context));
        }
    }

    public static void setUseMemoryIDGeneration() {
        usePersistenceIDGeneration = false;
        try {
            controller = new InMemoryIDController();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void setUseMemoryIDGeneration(boolean useInMemory) {
        if (useInMemory) {
            usePersistenceIDGeneration = false;
            controller = new InMemoryIDController();
        } else {
            usePersistenceIDGeneration = true;
            if (usePersistenceIDGeneration) {
                try {
                    controller = new PersistentIDController();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            } else {
                controller = new InMemoryIDController();
            }
        }
    }

    public static void shutDown() {
        if (controller != null) {
            controller.shutDown();
        }
    }

    private static synchronized DBIDGenerator getInstance() throws Exception {
        if (generator == null) {
            generator = new DBIDGenerator();
        }
        return generator;
    }

    private synchronized long getUniqueID(String context, boolean enableRollOver) throws DBIDGeneratorException {
        return controller.getUniqueID(context, enableRollOver);
    }

    private void setContextBlockSize(String context, long size) {
        controller.setContextBlockSize(context, size);
    }

    static {
        usePersistenceIDGeneration = true;
    }
}

