/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.jdbc;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FileCache {
    private static Set typesToCache = new HashSet();
    public static final long UNKNOWN_CHECKSUM = -1L;
    private Map map = new HashMap();

    public void addTypeToCache(String type) {
        typesToCache.add(type);
    }

    public long getChecksum(String filename) {
        FileCacheElement element = (FileCacheElement)this.map.get(filename);
        if (element == null) {
            return -1L;
        }
        return element.getChecksum();
    }

    public byte[] getBytes(String filename) {
        FileCacheElement element = (FileCacheElement)this.map.get(filename);
        if (element == null) {
            return null;
        }
        Reference reference = element.getBytesReference();
        byte[] bytes = (byte[])reference.get();
        if (bytes == null) {
            this.map.remove(filename);
        }
        return bytes;
    }

    public void put(String filename, long checksum, byte[] bytes, String type) {
        if (!typesToCache.contains(type)) {
            return;
        }
        FileCacheElement element = new FileCacheElement(filename, checksum, bytes);
        this.map.put(filename, element);
    }

    public int size() {
        return this.map.size();
    }

    private static class FileCacheElement {
        private String filename;
        private long checksum;
        private Reference bytesReference;

        public FileCacheElement(String filename, long checksum, byte[] bytes) {
            this.filename = filename;
            this.checksum = checksum;
            this.bytesReference = new SoftReference<byte[]>(bytes);
        }

        public String getFilename() {
            return this.filename;
        }

        public long getChecksum() {
            return this.checksum;
        }

        public Reference getBytesReference() {
            return this.bytesReference;
        }
    }
}

