/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule.spi.file;

import com.metamatrix.common.extensionmodule.spi.file.FileEMDescriptor;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.core.util.DateUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

class ManifestFile {
    private static final String JAR_SUFFIX = ".jar";
    private static final String SYSTEM_PRINCIPAL = "System";
    private String parentDirectory;
    private String filename;
    private long lastModified;
    Map descriptors = new HashMap();
    List orderedDescriptors = new ArrayList();

    ManifestFile(String parentDirectory, String filename) {
        this.parentDirectory = parentDirectory;
        this.filename = filename;
    }

    FileEMDescriptor getDescriptor(String name) {
        return (FileEMDescriptor)this.descriptors.get(name);
    }

    List getOrderedDescriptors() {
        return this.orderedDescriptors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean synch() throws IOException, NumberFormatException {
        CRC32 algorithm = null;
        boolean synched = false;
        File file = new File(this.parentDirectory, this.filename);
        if (!file.exists()) {
            this.createFile(file);
            synched = true;
            return synched;
        }
        if (file.lastModified() > this.lastModified) {
            this.descriptors.clear();
            this.orderedDescriptors.clear();
            this.readInFile(file);
            synched = true;
        }
        boolean append = true;
        Iterator i2 = this.orderedDescriptors.iterator();
        while (i2.hasNext()) {
            String timestamp;
            FileEMDescriptor desc = (FileEMDescriptor)i2.next();
            File module = new File(this.parentDirectory, desc.name);
            if (!module.exists()) {
                i2.remove();
                this.descriptors.remove(desc.name);
                append = false;
                continue;
            }
            if (module.lastModified() <= desc.timestamp) continue;
            desc.checksum = -1L;
            desc.timestamp = module.lastModified();
            desc.lastUpdatedDate = timestamp = DateUtil.getDateAsString(new Date(desc.timestamp));
            append = false;
        }
        File directory = new File(this.parentDirectory);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return !ManifestFile.this.descriptors.containsKey(name) && name.endsWith(ManifestFile.JAR_SUFFIX);
            }
        };
        File[] newJars = directory.listFiles(filter);
        if (!append || newJars.length > 0) {
            BufferedWriter manifestWriter = null;
            try {
                synched = true;
                if (!append) {
                    file.delete();
                }
                manifestWriter = new BufferedWriter(new FileWriter(file.getPath(), append));
                if (!append) {
                    i2 = this.orderedDescriptors.iterator();
                    while (i2.hasNext()) {
                        FileEMDescriptor desc = (FileEMDescriptor)i2.next();
                        if (desc.checksum == -1L) {
                            if (algorithm == null) {
                                algorithm = new CRC32();
                            }
                            this.recomputeChecksum(desc, algorithm);
                        }
                        String outputString = desc.writableString();
                        manifestWriter.write(outputString, 0, outputString.length());
                        if (!i2.hasNext()) continue;
                        manifestWriter.newLine();
                    }
                } else {
                    manifestWriter.newLine();
                }
                for (int j2 = 0; j2 < newJars.length; ++j2) {
                    if (algorithm == null) {
                        algorithm = new CRC32();
                    }
                    this.writeFileToManifest(j2, manifestWriter, newJars[j2], algorithm);
                    if (j2 == newJars.length - 1) continue;
                    manifestWriter.newLine();
                }
                this.lastModified = file.lastModified();
                Object var13_13 = null;
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (manifestWriter != null) {
                        manifestWriter.close();
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (manifestWriter != null) {
                    manifestWriter.close();
                }
            }
            catch (IOException e2) {}
        }
        return synched;
    }

    void init() throws IOException, NumberFormatException {
        File file = new File(this.parentDirectory, this.filename);
        if (!file.exists()) {
            this.createFile(file);
        } else {
            this.readInFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFile(File file) throws IOException {
        BufferedWriter manifestWriter = null;
        try {
            File directory = new File(this.parentDirectory);
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(ManifestFile.JAR_SUFFIX);
                }
            };
            File[] jarFiles = directory.listFiles(filter);
            CRC32 algorithm = new CRC32();
            manifestWriter = new BufferedWriter(new FileWriter(file));
            for (int i2 = 0; i2 < jarFiles.length; ++i2) {
                this.writeFileToManifest(i2, manifestWriter, jarFiles[i2], algorithm);
                if (i2 == jarFiles.length - 1) continue;
                manifestWriter.newLine();
            }
            manifestWriter.flush();
            manifestWriter.close();
            this.lastModified = new Date().getTime();
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (manifestWriter != null) {
                    manifestWriter.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (manifestWriter != null) {
                manifestWriter.close();
            }
        }
        catch (IOException e2) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readInFile(File file) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(file));
            int i2 = 0;
            String tokenizedString = in.readLine();
            while (tokenizedString != null) {
                if (tokenizedString.trim().length() > 0) {
                    FileEMDescriptor desc = new FileEMDescriptor(i2, tokenizedString);
                    ++i2;
                    this.descriptors.put(desc.name, desc);
                    this.orderedDescriptors.add(desc);
                }
                tokenizedString = in.readLine();
            }
            this.lastModified = file.lastModified();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
        }
        catch (IOException e2) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFileToManifest(int searchPosition, BufferedWriter manifestWriter, File file, Checksum algorithm) throws IOException {
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            int size = (int)file.length();
            byte[] data = ByteArrayHelper.toByteArray(stream, size + 1);
            algorithm.reset();
            algorithm.update(data, 0, data.length);
            FileEMDescriptor desc = new FileEMDescriptor(file.getName(), searchPosition, SYSTEM_PRINCIPAL, DateUtil.getCurrentDateAsString(), algorithm.getValue(), file.lastModified());
            String outputString = desc.writableString();
            manifestWriter.write(outputString, 0, outputString.length());
            this.descriptors.put(desc.name, desc);
            this.orderedDescriptors.add(desc);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e2) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recomputeChecksum(FileEMDescriptor desc, Checksum algorithm) throws IOException {
        FileInputStream stream = null;
        try {
            File aFile = new File(this.parentDirectory, desc.name);
            stream = new FileInputStream(aFile);
            int size = (int)aFile.length();
            byte[] data = ByteArrayHelper.toByteArray(stream, size + 1);
            algorithm.reset();
            algorithm.update(data, 0, data.length);
            desc.checksum = algorithm.getValue();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e2) {}
    }
}

