/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.extensionmodule;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.CurrentConfiguration;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.extensionmodule.ExtensionModuleManager;
import com.metamatrix.common.extensionmodule.exception.DuplicateExtensionModuleException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.exception.InvalidExtensionModuleTypeException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class ExtensionModuleInstallUtil {
    private static final String LOG_CONTEXT = "EXTENSION_MODULE";
    ExtensionModuleManager manager = null;

    public ExtensionModuleInstallUtil(Properties overrideResourceProps) {
        Properties props = overrideResourceProps;
        if (props == null) {
            props = new Properties();
        }
        Properties resourceProps = null;
        try {
            resourceProps = CurrentConfiguration.getResourceProperties("ExtensionSourceManager");
        }
        catch (Exception e2) {
            LogManager.logError(LOG_CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0001"));
        }
        if (resourceProps != null) {
            boolean deepClone = true;
            boolean makeUnmodifiable = false;
            props = PropertiesUtils.clone(props, resourceProps, deepClone, makeUnmodifiable);
        }
        this.manager = ExtensionModuleManager.getInstance(props);
    }

    public ExtensionModuleDescriptor installExtensionModule(String fileName, String parentPath, String type, String principal) throws DuplicateExtensionModuleException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        return this.installExtensionModule(fileName, parentPath, type, principal, null, fileName);
    }

    /*
     * Loose catch block
     */
    public ExtensionModuleDescriptor installExtensionModule(String fileName, String parentPath, String type, String principal, String description, String alternateName) throws DuplicateExtensionModuleException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        ExtensionModuleDescriptor esd;
        block12: {
            InputStream stream;
            block11: {
                ArgCheck.isNotNull(fileName);
                ArgCheck.isNotNull(parentPath);
                ArgCheck.isNotNull(principal);
                ArgCheck.isNotNull(type);
                ArgCheck.isNotZeroLength(type);
                ArgCheck.isNotZeroLength(principal);
                ArgCheck.isNotZeroLength(fileName);
                ArgCheck.isNotZeroLength(parentPath);
                if (alternateName == null) {
                    alternateName = fileName;
                }
                stream = null;
                byte[] data = null;
                esd = null;
                File aFile = new File(parentPath, fileName);
                stream = new FileInputStream(aFile);
                int size = (int)aFile.length();
                data = ByteArrayHelper.toByteArray(stream, size + 1);
                if (this.manager.isSourceInUse(alternateName)) {
                    esd = this.manager.setSource(principal, alternateName, data);
                    break block11;
                }
                esd = this.manager.addSource(principal, type, alternateName, data, description, true);
            }
            Object var13_13 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
                break block12;
            }
            catch (IOException e2) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0003"));
            }
            break block12;
            {
                catch (Exception e3) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e3, CommonPlugin.Util.getString("ERR.014.004.0002", fileName));
                    throw new MetaMatrixComponentException(e3);
                }
            }
            catch (Throwable throwable) {
                Object var13_14 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    LogManager.logWarning(LOG_CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0003"));
                }
                throw throwable;
            }
        }
        return esd;
    }

    /*
     * Loose catch block
     */
    public ExtensionModuleDescriptor installExtensionModule(String fileFullPath, String type, String principal, String description, String assignedName) throws DuplicateExtensionModuleException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        ExtensionModuleDescriptor esd;
        block11: {
            InputStream stream;
            block10: {
                ArgCheck.isNotNull(fileFullPath);
                ArgCheck.isNotNull(type);
                ArgCheck.isNotNull(principal);
                ArgCheck.isNotNull(assignedName);
                ArgCheck.isNotNull(description);
                ArgCheck.isNotZeroLength(fileFullPath);
                ArgCheck.isNotZeroLength(type);
                ArgCheck.isNotZeroLength(principal);
                ArgCheck.isNotZeroLength(assignedName);
                ArgCheck.isNotZeroLength(description);
                stream = null;
                byte[] data = null;
                esd = null;
                File aFile = new File(fileFullPath);
                stream = new FileInputStream(aFile);
                int size = (int)aFile.length();
                data = ByteArrayHelper.toByteArray(stream, size + 1);
                if (this.manager.isSourceInUse(assignedName)) {
                    esd = this.manager.setSource(principal, assignedName, data);
                    break block10;
                }
                esd = this.manager.addSource(principal, type, assignedName, data, description, true);
            }
            Object var12_12 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
                break block11;
            }
            catch (IOException e2) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0003"));
            }
            break block11;
            {
                catch (Exception e3) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e3, CommonPlugin.Util.getString("ERR.014.004.0002", fileFullPath));
                    throw new MetaMatrixComponentException(e3);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    LogManager.logWarning(LOG_CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0003"));
                }
                throw throwable;
            }
        }
        return esd;
    }

    /*
     * Loose catch block
     */
    public void updateExtensionModule(String fileFullPath, String sourceName, String principal) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        block10: {
            ArgCheck.isNotNull(fileFullPath);
            ArgCheck.isNotNull(principal);
            ArgCheck.isNotNull(sourceName);
            ArgCheck.isNotZeroLength(fileFullPath);
            ArgCheck.isNotZeroLength(principal);
            ArgCheck.isNotZeroLength(sourceName);
            InputStream stream = null;
            byte[] data = null;
            File aFile = new File(fileFullPath);
            data = ByteArrayHelper.toByteArray(aFile);
            if (!this.manager.isSourceInUse(sourceName)) {
                throw new ExtensionModuleNotFoundException("ERR.014.004.0004", CommonPlugin.Util.getString("ERR.014.004.0004", sourceName));
            }
            this.manager.setSource(principal, sourceName, data);
            Object var8_8 = null;
            try {
                if (stream != null) {
                    stream.close();
                }
                break block10;
            }
            catch (IOException e2) {
                LogManager.logWarning(LOG_CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0003"));
            }
            break block10;
            {
                catch (Exception e3) {
                    LogManager.logError(LOG_CONTEXT, (Throwable)e3, CommonPlugin.Util.getString("ERR.014.004.0002", fileFullPath));
                    throw new MetaMatrixComponentException(e3);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e2) {
                    LogManager.logWarning(LOG_CONTEXT, (Throwable)e2, CommonPlugin.Util.getString("ERR.014.004.0003"));
                }
                throw throwable;
            }
        }
    }

    public ExtensionModuleDescriptor exportExtensionModule(OutputStream outputStream, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleDescriptor source = null;
        source = this.manager.getSourceDescriptor(sourceName);
        byte[] data = this.manager.getSource(sourceName);
        if (data == null || data.length == 0) {
            throw new ExtensionModuleNotFoundException("ERR.014.004.0004", CommonPlugin.Util.getString("ERR.014.004.0004", sourceName));
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        BufferedInputStream is = new BufferedInputStream(bais);
        try {
            int bytesRead;
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = ((InputStream)is).read(buff, 0, buff.length))) {
                outputStream.write(buff, 0, bytesRead);
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException((Throwable)e2, "ERR.014.004.0005", CommonPlugin.Util.getString("ERR.014.004.0005", sourceName));
        }
        return source;
    }

    public ExtensionModuleDescriptor exportExtensionModule(String outputFileName, String sourceName) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleDescriptor source = null;
        source = this.manager.getSourceDescriptor(sourceName);
        byte[] data = this.manager.getSource(sourceName);
        if (data == null || data.length == 0) {
            throw new ExtensionModuleNotFoundException("ERR.014.004.0004", CommonPlugin.Util.getString("ERR.014.004.0004", sourceName));
        }
        try {
            FileUtils.write(data, outputFileName);
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException((Throwable)e2, "ERR.014.004.0006", CommonPlugin.Util.getString("ERR.014.004.0006", sourceName, outputFileName));
        }
        return source;
    }

    public List exportExtensionModulesOfType(String type, String outputDirectory) throws ExtensionModuleNotFoundException, MetaMatrixComponentException {
        ExtensionModuleDescriptor source = null;
        String sourceName = "";
        String outputfile = "";
        try {
            List sds = this.manager.getSourceDescriptors(type);
            if (sds == null) {
                return Collections.EMPTY_LIST;
            }
            Iterator it = sds.iterator();
            while (it.hasNext()) {
                source = (ExtensionModuleDescriptor)it.next();
                sourceName = source.getName();
                outputfile = FileUtils.buildDirectoryPath(new String[]{outputDirectory != null ? outputDirectory : "", sourceName});
                this.exportExtensionModule(outputfile, source.getName());
            }
            return sds;
        }
        catch (ExtensionModuleNotFoundException notFound) {
            throw notFound;
        }
        catch (MetaMatrixComponentException compException) {
            throw compException;
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException((Throwable)e2, "ERR.014.004.0006", CommonPlugin.Util.getString("ERR.014.004.0006", sourceName, outputfile));
        }
    }

    public void removeExtensionModule(String extensionName, String principal) throws ExtensionModuleNotFoundException, InvalidExtensionModuleTypeException, MetaMatrixComponentException {
        ArgCheck.isNotNull(extensionName);
        ArgCheck.isNotZeroLength(extensionName);
        try {
            if (!this.manager.isSourceInUse(extensionName)) {
                throw new ExtensionModuleNotFoundException("ERR.014.004.0004", CommonPlugin.Util.getString("ERR.014.004.0004", extensionName));
            }
            this.manager.removeSource(principal, extensionName);
        }
        catch (ExtensionModuleNotFoundException ne) {
            throw ne;
        }
        catch (Exception e2) {
            throw new MetaMatrixComponentException((Throwable)e2, "ERR.014.004.0071", CommonPlugin.Util.getString("ERR.014.004.0071", extensionName));
        }
    }
}

