/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.xml;

import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.model.BasicUtil;
import com.metamatrix.common.config.xml.XMLConfig_42_HelperImpl;
import com.metamatrix.core.util.Assertion;
import org.jdom.Element;

public class XMLConfig_42_Visitor {
    private XMLConfig_42_HelperImpl helper;
    private ConfigurationObjectEditor editor;

    public XMLConfig_42_Visitor(XMLConfig_42_HelperImpl impl) {
        this.helper = impl;
    }

    public XMLConfig_42_Visitor(XMLConfig_42_HelperImpl impl, ConfigurationObjectEditor configEditor) {
        this.helper = impl;
        this.editor = configEditor;
    }

    public ConfigurationObjectEditor getEditor() {
        return this.editor;
    }

    Element visitComponent(ComponentType component) {
        if (component instanceof ProductType) {
            return this.helper.createProductTypeElement((ProductType)component);
        }
        return this.helper.createComponentTypeElement(component);
    }

    Element visitComponent(ComponentObject component) {
        Assertion.isNotNull(component);
        switch (BasicUtil.getComponentDefnType(component)) {
            case 5: {
                return this.helper.createVMComponentDefnElement((VMComponentDefn)component);
            }
            case 6: {
                return this.helper.createProductServiceConfigElement((ProductServiceConfig)component);
            }
            case 2: {
                return this.helper.createServiceComponentDefnElement((ServiceComponentDefn)component);
            }
            case 1: {
                return this.helper.createServiceComponentDefnElement((ServiceComponentDefn)component);
            }
            case 9: {
                return this.helper.createResourcePoolElement((ResourceDescriptor)component);
            }
            case 7: {
                return this.helper.createDeployedHostElement((Host)component);
            }
            case 0: {
                return this.helper.createConfigurationElement((Configuration)component);
            }
            case 8: {
                return this.helper.createDeployedComponentElement((DeployedComponent)component);
            }
            case 10: {
                return this.helper.createSharedResourceElement((SharedResource)component);
            }
            case 3: {
                return this.helper.createProductTypeElement((ProductType)((Object)component));
            }
        }
        return null;
    }

    Element visitConnectorBindingComponent(ComponentObject component) {
        Assertion.isNotNull(component);
        return this.helper.createConnectorBindingElement((ConnectorBinding)component, true);
    }
}

