/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.xml;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.model.BasicConnectorArchive;
import com.metamatrix.common.config.model.BasicExtensionModule;
import com.metamatrix.common.config.util.ConfigObjectsNotResolvableException;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.util.ByteArrayHelper;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.internal.core.xml.JdomHelper;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

class ConnectorArchiveImportExportUtility {
    private static final String DEPLOYMENT_MANIFEST = "DeploymentManifest";
    private static final String EXTENSION_MODULE = "ExtensionModule";
    private static final String EXTENSION_MODULES = "ExtensionModules";
    private static final String TYPE = "Type";
    private static final String FILE = "File";
    private static final String NAME = "Name";
    private static final String CONNECTOR_TYPE = "ConnectorType";
    private static final String CONNECTOR_TYPES = "ConnectorTypes";
    private static final String SHARED = "Shared";
    private static final String MANIFEST_XML = "Manifest.xml";
    private static final String FWD_SLASH = "/";
    static Random random = new Random();

    ConnectorArchiveImportExportUtility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectorArchive importConnectorArchive(InputStream stream, ConfigurationObjectEditor editor, XMLConfigurationImportExportUtility util) throws IOException, InvalidConfigurationElementException {
        BasicConnectorArchive archive = new BasicConnectorArchive();
        TempDirectory tempDir = new TempDirectory(System.currentTimeMillis(), random.nextLong());
        tempDir.create();
        try {
            File cafFile = new File(tempDir.getPath(), "ConnectorArchive_" + random.nextLong() + ".zip");
            FileUtils.write(stream, cafFile);
            this.extractConnectorTypes(cafFile, editor, util, archive);
            ConnectorBindingType[] types = archive.getConnectorTypes();
            for (int i2 = 0; i2 < types.length; ++i2) {
                this.extractExtensionModules(cafFile, types[i2], archive);
            }
            this.extractManifest(cafFile, archive);
        }
        finally {
            tempDir.remove();
        }
        this.validateArchive(archive);
        return archive;
    }

    void extractConnectorTypes(File cafFile, ConfigurationObjectEditor editor, XMLConfigurationImportExportUtility util, BasicConnectorArchive archive) throws IOException, InvalidConfigurationElementException {
        ZipFile zip = new ZipFile(cafFile);
        Enumeration<? extends ZipEntry> e2 = zip.entries();
        while (e2.hasMoreElements()) {
            ZipEntry entry = e2.nextElement();
            String entryName = entry.getName();
            String fileName = entryName.substring(entryName.lastIndexOf(47) + 1);
            if (entry.isDirectory() || !entryName.matches("^ConnectorTypes\\/.*\\/.*\\.cdk$")) continue;
            InputStream in = zip.getInputStream(entry);
            String cbName = fileName.substring(0, fileName.length() - 4);
            ComponentType type = util.importComponentType(in, editor, cbName);
            archive.addConnectorType((ConnectorBindingType)type);
        }
        zip.close();
    }

    void extractExtensionModules(File cafFile, ConnectorBindingType type, BasicConnectorArchive archive) throws IOException {
        String[] extModuleNames = type.getExtensionModules();
        ZipFile zip = new ZipFile(cafFile);
        Enumeration<? extends ZipEntry> e2 = zip.entries();
        while (e2.hasMoreElements()) {
            ZipEntry entry = e2.nextElement();
            String entryName = entry.getName();
            String fileName = entryName.substring(entryName.lastIndexOf(47) + 1);
            if (entry.isDirectory()) continue;
            for (int i2 = 0; i2 < extModuleNames.length; ++i2) {
                if (!entryName.equals("ConnectorTypes/" + type.getName() + FWD_SLASH + extModuleNames[i2]) && !entryName.equals("ConnectorTypes/Shared/" + extModuleNames[i2])) continue;
                InputStream in = zip.getInputStream(entry);
                BasicExtensionModule module = new BasicExtensionModule(fileName, entry.getComment(), ByteArrayHelper.toByteArray(in));
                archive.addExtensionModule(type, module);
            }
        }
        zip.close();
    }

    void extractManifest(File cafFile, BasicConnectorArchive archive) throws IOException {
        ZipFile zip = new ZipFile(cafFile);
        Enumeration<? extends ZipEntry> e2 = zip.entries();
        while (e2.hasMoreElements()) {
            ZipEntry entry = e2.nextElement();
            String entryName = entry.getName();
            if (entry.isDirectory() || !entryName.matches(MANIFEST_XML)) continue;
            InputStream in = zip.getInputStream(entry);
            archive.addMainfestContents(ByteArrayHelper.toByteArray(in));
        }
        zip.close();
    }

    public void exportConnectorArchive(OutputStream stream, ConnectorArchive archive, Properties properties, XMLConfigurationImportExportUtility util) throws IOException, ConfigObjectsNotResolvableException {
        this.validateArchive(archive);
        Manifest mainfest = this.createManifest(archive);
        ZipOutputStream zipstream = new ZipOutputStream(stream);
        zipstream.putNextEntry(new ZipEntry("ConnectorTypes/"));
        zipstream.closeEntry();
        HashSet<String> writtenSharedFiles = new HashSet<String>();
        ConnectorBindingType[] types = archive.getConnectorTypes();
        for (int typeIdx = 0; typeIdx < types.length; ++typeIdx) {
            ConnectorBindingType type = types[typeIdx];
            zipstream.putNextEntry(new ZipEntry("ConnectorTypes/" + type.getName() + FWD_SLASH));
            zipstream.closeEntry();
            ZipEntry entry = new ZipEntry(this.getConnectorTypeFileName(type));
            zipstream.putNextEntry(entry);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
            util.exportComponentType(baos, type, properties);
            zipstream.write(baos.toByteArray());
            zipstream.closeEntry();
            baos.close();
            ExtensionModule[] extModules = archive.getExtensionModules(type);
            for (int i2 = 0; i2 < extModules.length; ++i2) {
                if (!mainfest.isShared(extModules[i2].getFullName())) {
                    entry = new ZipEntry(this.getExtensionModuleFileName(type, extModules[i2]));
                    zipstream.putNextEntry(entry);
                    zipstream.write(extModules[i2].getFileContents());
                    zipstream.closeEntry();
                    continue;
                }
                if (writtenSharedFiles.contains(extModules[i2].getFullName())) continue;
                entry = new ZipEntry(this.getSharedExtensionModuleFileName(extModules[i2]));
                zipstream.putNextEntry(entry);
                zipstream.write(extModules[i2].getFileContents());
                zipstream.closeEntry();
                writtenSharedFiles.add(extModules[i2].getFullName());
            }
        }
        byte[] manifest = this.createManifestFile(archive, mainfest);
        if (manifest != null) {
            ZipEntry entry = new ZipEntry(MANIFEST_XML);
            zipstream.putNextEntry(entry);
            zipstream.write(manifest);
            zipstream.closeEntry();
        }
        zipstream.finish();
    }

    Manifest createManifest(ConnectorArchive archive) {
        Manifest manifest = new Manifest();
        ConnectorBindingType[] types = archive.getConnectorTypes();
        for (int currentType = 0; currentType < types.length; ++currentType) {
            ExtensionModule[] currentModules = archive.getExtensionModules(types[currentType]);
            for (int currentModule = 0; currentModule < currentModules.length; ++currentModule) {
                boolean shared = false;
                for (int nextType = currentType + 1; nextType < types.length; ++nextType) {
                    ExtensionModule[] nextModules = archive.getExtensionModules(types[nextType]);
                    for (int nextModule = 0; nextModule < nextModules.length; ++nextModule) {
                        if (!nextModules[nextModule].getFullName().equals(currentModules[currentModule].getFullName())) continue;
                        manifest.addShared(currentModules[currentModule].getFullName(), types[currentType].getName(), types[nextType].getName());
                        shared = true;
                    }
                }
                if (shared || manifest.isShared(currentModules[currentModule].getFullName())) continue;
                manifest.addPrivate(types[currentType].getName(), currentModules[currentModule].getFullName());
            }
        }
        return manifest;
    }

    byte[] createManifestFile(ConnectorArchive archive, Manifest manifest) throws IOException {
        Element root = new Element(DEPLOYMENT_MANIFEST);
        Element connectorTypesElement = new Element(CONNECTOR_TYPES);
        ConnectorBindingType[] types = archive.getConnectorTypes();
        for (int typeIdx = 0; typeIdx < types.length; ++typeIdx) {
            ConnectorBindingType type = types[typeIdx];
            Element typeElement = new Element(CONNECTOR_TYPE);
            typeElement.setAttribute(NAME, type.getName());
            typeElement.setAttribute(FILE, this.getConnectorTypeFileName(type));
            Element extensionModulesElement = new Element(EXTENSION_MODULES);
            ExtensionModule[] extModules = archive.getExtensionModules(type);
            for (int i2 = 0; i2 < extModules.length; ++i2) {
                Element extensionModuleElement = new Element(EXTENSION_MODULE);
                extensionModuleElement.setAttribute(TYPE, extModules[i2].getModuleType());
                if (manifest.isShared(extModules[i2].getFullName())) {
                    extensionModuleElement.setAttribute(FILE, this.getSharedExtensionModuleFileName(extModules[i2]));
                } else {
                    extensionModuleElement.setAttribute(FILE, this.getExtensionModuleFileName(type, extModules[i2]));
                }
                extensionModulesElement.addContent(extensionModuleElement);
            }
            typeElement.addContent(extensionModulesElement);
            connectorTypesElement.addContent(typeElement);
        }
        root.addContent(connectorTypesElement);
        Document doc = new Document(root);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLOutputter outputter = new XMLOutputter(JdomHelper.getFormat("    ", true));
        outputter.output(doc, (OutputStream)bos);
        bos.flush();
        bos.close();
        return bos.toByteArray();
    }

    private String getConnectorTypeFileName(ConnectorBindingType type) {
        return "ConnectorTypes/" + type.getName() + FWD_SLASH + type.getName() + ".cdk";
    }

    private String getExtensionModuleFileName(ConnectorBindingType type, ExtensionModule module) {
        return "ConnectorTypes/" + type.getName() + FWD_SLASH + module.getFullName();
    }

    private String getSharedExtensionModuleFileName(ExtensionModule module) {
        return "ConnectorTypes/Shared/" + module.getFullName();
    }

    boolean validateArchive(ConnectorArchive archive) {
        ConnectorBindingType[] types = archive.getConnectorTypes();
        for (int typeIdx = 0; typeIdx < types.length; ++typeIdx) {
            ConnectorBindingType type = types[typeIdx];
            String[] expectedModules = type.getExtensionModules();
            ExtensionModule[] foundModules = archive.getExtensionModules(type);
            for (int i2 = 0; i2 < expectedModules.length; ++i2) {
                boolean found = false;
                String moduleName = expectedModules[i2];
                for (int j2 = 0; j2 < foundModules.length; ++j2) {
                    ExtensionModule foundModule = foundModules[j2];
                    if (!foundModule.getFullName().equals(moduleName)) continue;
                    found = true;
                }
                if (found) continue;
                CommonPlugin.Util.log(2, CommonPlugin.Util.getString("ConnectorArchiveImportExportUtility.Invalid_archive_missing_jars", new Object[]{moduleName, type.getName()}));
            }
        }
        return true;
    }

    static class Manifest {
        HashMap sharedList = new HashMap();
        HashMap connectorList = new HashMap();

        Manifest() {
        }

        void addShared(String extName, String type1, String type2) {
            HashSet<String> list = (HashSet<String>)this.sharedList.get(extName);
            if (list == null) {
                list = new HashSet<String>();
            }
            list.add(type1);
            list.add(type2);
            this.sharedList.put(extName, list);
        }

        boolean isShared(String extName) {
            return this.sharedList.containsKey(extName);
        }

        void addPrivate(String type, String extName) {
            HashSet<String> list = (HashSet<String>)this.connectorList.get(type);
            if (list == null) {
                list = new HashSet<String>();
            }
            list.add(extName);
            this.connectorList.put(type, list);
        }
    }
}

