/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingID;
import com.metamatrix.common.config.api.DeployedComponent;
import com.metamatrix.common.config.api.DeployedComponentID;
import com.metamatrix.common.config.api.Host;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ProductServiceConfig;
import com.metamatrix.common.config.api.ProductServiceConfigID;
import com.metamatrix.common.config.api.ProductType;
import com.metamatrix.common.config.api.ProductTypeID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.common.config.api.ResourceDescriptorID;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.SharedResource;
import com.metamatrix.common.config.api.SharedResourceID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.VMComponentDefnID;
import com.metamatrix.common.config.model.BasicComponentDefn;
import com.metamatrix.common.config.model.BasicComponentObject;
import com.metamatrix.common.config.model.BasicComponentType;
import com.metamatrix.common.config.model.BasicConnectorBinding;
import com.metamatrix.common.config.model.BasicConnectorBindingType;
import com.metamatrix.common.config.model.BasicDeployedComponent;
import com.metamatrix.common.config.model.BasicHost;
import com.metamatrix.common.config.model.BasicHostType;
import com.metamatrix.common.config.model.BasicProductServiceConfig;
import com.metamatrix.common.config.model.BasicProductServiceConfigType;
import com.metamatrix.common.config.model.BasicProductType;
import com.metamatrix.common.config.model.BasicResourceComponentType;
import com.metamatrix.common.config.model.BasicResourceDescriptor;
import com.metamatrix.common.config.model.BasicServiceComponentDefn;
import com.metamatrix.common.config.model.BasicServiceComponentType;
import com.metamatrix.common.config.model.BasicSharedResource;
import com.metamatrix.common.config.model.BasicVMComponentDefn;
import com.metamatrix.common.config.model.BasicVMComponentDefnType;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.namedobject.BaseObject;
import com.metamatrix.core.util.Assertion;

public class BasicUtil {
    public static final BasicComponentDefn createComponentDefn(int defnTypeCode, ConfigurationID configID, ComponentTypeID typeID, String defnName) {
        BasicComponentDefn defn = null;
        if (defnTypeCode == 9) {
            ResourceDescriptorID descriptorID = new ResourceDescriptorID(configID, defnName);
            defn = new BasicResourceDescriptor(configID, descriptorID, typeID);
        } else if (defnTypeCode == 2) {
            ConnectorBindingID conID = new ConnectorBindingID(configID, defnName);
            defn = new BasicConnectorBinding(configID, conID, typeID);
        } else if (defnTypeCode == 7) {
            HostID conID = new HostID(defnName);
            defn = new BasicHost(configID, conID, typeID);
        } else if (defnTypeCode == 1) {
            ServiceComponentDefnID sID = new ServiceComponentDefnID(configID, defnName);
            defn = new BasicServiceComponentDefn(configID, sID, typeID);
        } else {
            Assertion.assertTrue(true, "DefnTypeCode:" + defnTypeCode + " is not defined in BasicUtil.createComponentDefn");
        }
        return defn;
    }

    public static final BasicComponentDefn createComponentDefn(int defnTypeCode, ConfigurationID configID, HostID hostID, ComponentTypeID typeID, String defnName) {
        BasicVMComponentDefn defn = null;
        if (defnTypeCode == 5) {
            VMComponentDefnID vmID = new VMComponentDefnID(configID, hostID, defnName);
            defn = new BasicVMComponentDefn(configID, hostID, vmID, typeID);
        }
        return defn;
    }

    public static final BasicComponentDefn createComponentDefn(int defnTypeCode, ConfigurationID configID, ProductTypeID typeID, String defnName) {
        BasicProductServiceConfig defn = null;
        if (defnTypeCode == 6) {
            ProductServiceConfigID pscID = new ProductServiceConfigID(configID, defnName);
            defn = new BasicProductServiceConfig(configID, pscID, typeID);
        } else {
            Assertion.assertTrue(true, "DefnTypeCode:" + defnTypeCode + " is not defined in BasicUtil.createComponentDefn");
        }
        return defn;
    }

    public static final BasicComponentObject createComponentObject(int defnTypeCode, ComponentTypeID typeID, String objName) {
        BasicSharedResource defn = null;
        if (defnTypeCode == 10) {
            SharedResourceID id = new SharedResourceID(objName);
            defn = new BasicSharedResource(id, typeID);
        } else {
            Assertion.assertTrue(true, "DefnTypeCode:" + defnTypeCode + " is not defined in BasicUtil.createComponentObject");
        }
        return defn;
    }

    public static BasicComponentType createComponentType(int classTypeCode, String name, ComponentTypeID parentID, ComponentTypeID superID, boolean deployable, boolean monitored) {
        ComponentTypeID typeID = new ComponentTypeID(name);
        BasicComponentType type = null;
        if (name.equalsIgnoreCase("VM")) {
            type = new BasicVMComponentDefnType(typeID, parentID, superID, deployable, false, monitored);
            classTypeCode = 5;
        } else if (name.equalsIgnoreCase("Host")) {
            type = new BasicHostType(typeID, parentID, superID, deployable, false, monitored);
            classTypeCode = 7;
        } else if (name.equalsIgnoreCase("Configuration")) {
            type = new BasicComponentType(typeID, parentID, superID, deployable, false, monitored);
            classTypeCode = 0;
        } else if (name.equalsIgnoreCase("ProductServiceConfig")) {
            type = new BasicProductServiceConfigType(typeID, parentID, superID, deployable, false, monitored);
            classTypeCode = 6;
        } else if (name.equalsIgnoreCase("DeployedComponent")) {
            type = new BasicComponentType(typeID, parentID, superID, deployable, false, monitored);
            classTypeCode = 8;
        } else if (classTypeCode == 3) {
            ProductTypeID prodtypeID = new ProductTypeID(name);
            classTypeCode = 3;
            type = new BasicProductType(prodtypeID, parentID, superID, deployable, false, monitored);
        } else if (classTypeCode == 2) {
            type = new BasicConnectorBindingType(typeID, parentID, superID, deployable, false, monitored);
        } else if (classTypeCode == 1) {
            type = new BasicServiceComponentType(typeID, parentID, superID, deployable, false, monitored);
        } else if (classTypeCode == 6) {
            type = new BasicProductServiceConfigType(typeID, parentID, superID, deployable, false, monitored);
        } else if (classTypeCode == 0) {
            type = new BasicComponentType(typeID, parentID, superID, deployable, false, monitored);
        } else if (classTypeCode == 4) {
            type = new BasicResourceComponentType(typeID, parentID, superID, deployable, false, monitored);
        } else {
            Assertion.assertTrue(true, "ClassTypeCode:" + classTypeCode + " is not defined in BasicUtil.createComponentType");
        }
        type.setComponentTypeCode(classTypeCode);
        return type;
    }

    public static BasicDeployedComponent createDeployedComponent(String name, ConfigurationID configID, HostID hostID, VMComponentDefnID vmID, ServiceComponentDefnID svcID, ProductServiceConfigID pscID, ComponentTypeID typeID) {
        DeployedComponentID id = new DeployedComponentID(name, configID, hostID, vmID, pscID, svcID);
        BasicDeployedComponent deployComponent = new BasicDeployedComponent(id, configID, hostID, vmID, svcID, pscID, typeID);
        return deployComponent;
    }

    public static BasicDeployedComponent createDeployedVMComponent(String name, ConfigurationID configID, HostID hostID, VMComponentDefnID vmID, ComponentTypeID vmtypeID) {
        DeployedComponentID id = new DeployedComponentID(name, configID, hostID, vmID);
        BasicDeployedComponent deployComponent = new BasicDeployedComponent(id, configID, hostID, vmID, vmtypeID);
        return deployComponent;
    }

    public static int getComponentType(BaseObject defn) {
        if (defn instanceof Host) {
            return 7;
        }
        if (defn instanceof ProductServiceConfig) {
            return 6;
        }
        if (defn instanceof VMComponentDefn) {
            return 5;
        }
        if (defn instanceof ConnectorBinding) {
            return 2;
        }
        if (defn instanceof ResourceDescriptor) {
            return 4;
        }
        if (defn instanceof ServiceComponentDefn) {
            return 1;
        }
        if (defn instanceof Configuration) {
            return 0;
        }
        if (defn instanceof DeployedComponent) {
            return 8;
        }
        Assertion.assertTrue(false, "Process Error: component object of type " + defn.getClass().getName() + " not accounted for.");
        return -1;
    }

    static int getComponentType(BaseID defnID) {
        if (defnID instanceof HostID) {
            return 7;
        }
        if (defnID instanceof ProductServiceConfigID) {
            return 6;
        }
        if (defnID instanceof VMComponentDefnID) {
            return 5;
        }
        if (defnID instanceof ResourceDescriptorID) {
            return 4;
        }
        if (defnID instanceof SharedResourceID) {
            return 4;
        }
        if (defnID instanceof ConnectorBindingID) {
            return 2;
        }
        if (defnID instanceof ServiceComponentDefnID) {
            return 1;
        }
        if (defnID instanceof ConfigurationID) {
            return 0;
        }
        if (defnID instanceof DeployedComponentID) {
            return 8;
        }
        Assertion.assertTrue(false, "Process Error: component object of type " + defnID.getClass().getName() + " not accounted for.");
        return -1;
    }

    public static int getComponentDefnType(BaseObject defn) {
        if (defn instanceof Host) {
            return 7;
        }
        if (defn instanceof ProductServiceConfig) {
            return 6;
        }
        if (defn instanceof VMComponentDefn) {
            return 5;
        }
        if (defn instanceof ConnectorBinding) {
            return 2;
        }
        if (defn instanceof ResourceDescriptor) {
            return 9;
        }
        if (defn instanceof ServiceComponentDefn) {
            return 1;
        }
        if (defn instanceof Configuration) {
            return 0;
        }
        if (defn instanceof DeployedComponent) {
            return 8;
        }
        if (defn instanceof SharedResource) {
            return 10;
        }
        if (defn instanceof ProductType) {
            return 3;
        }
        Assertion.assertTrue(false, "Process Error: component defn object of type " + defn.getClass().getName() + " not accounted for.");
        return -1;
    }

    public static int getComponentDefnType(BaseID id) {
        if (id instanceof HostID) {
            return 7;
        }
        if (id instanceof ProductServiceConfigID) {
            return 6;
        }
        if (id instanceof VMComponentDefnID) {
            return 5;
        }
        if (id instanceof ConnectorBindingID) {
            return 2;
        }
        if (id instanceof ResourceDescriptorID) {
            return 9;
        }
        if (id instanceof ServiceComponentDefnID) {
            return 1;
        }
        if (id instanceof ConfigurationID) {
            return 0;
        }
        if (id instanceof DeployedComponentID) {
            return 8;
        }
        if (id instanceof SharedResourceID) {
            return 10;
        }
        if (id instanceof ProductTypeID) {
            return 3;
        }
        Assertion.assertTrue(false, "Process Error: component defn object of type " + id.getClass().getName() + " not accounted for.");
        return -1;
    }
}

