/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.api.ResourceDescriptorID;
import com.metamatrix.common.config.model.BasicComponentDefn;

public class BasicExtensionModule
extends BasicComponentDefn
implements ExtensionModule {
    private String type = null;
    private byte[] contents = null;

    public BasicExtensionModule(String name, String type, String description, byte[] contents) {
        super(new ConfigurationID(name), new ExtensionID(name), new ComponentTypeID(name));
        this.type = type;
        this.contents = contents;
        this.setDescription(description);
        if (contents == null || type == null) {
            throw new IllegalArgumentException();
        }
    }

    public BasicExtensionModule(String name, String description, byte[] contents) {
        super(new ConfigurationID(name), new ExtensionID(name), new ComponentTypeID(name));
        this.type = BasicExtensionModule.sniffType(name);
        this.contents = contents;
        this.setDescription(description);
        if (contents == null) {
            throw new IllegalArgumentException();
        }
    }

    protected BasicExtensionModule(BasicExtensionModule component) {
        super(component);
    }

    public byte[] getFileContents() {
        return this.contents;
    }

    public String getModuleType() {
        return this.type;
    }

    public Object clone() throws CloneNotSupportedException {
        return new CloneNotSupportedException();
    }

    void setModuleType(String type) {
        this.type = type;
    }

    void setFileContents(byte[] contents) {
        this.contents = contents;
    }

    static String sniffType(String name) {
        if ((name = name.toLowerCase()).endsWith(".jar")) {
            return "JAR File";
        }
        if (name.endsWith(".vdb")) {
            return "JAR File";
        }
        if (name.endsWith(".udf")) {
            return "Function Definition";
        }
        return "Miscellaneous Type";
    }

    static class ExtensionID
    extends ResourceDescriptorID {
        public ExtensionID(String name) {
            super(name);
        }
    }
}

