/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ComponentTypeDefn;
import com.metamatrix.common.config.api.ComponentTypeDefnID;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ComponentTypePropDefn;
import com.metamatrix.common.namedobject.BasicObject;
import com.metamatrix.common.object.PropertyDefinition;
import com.metamatrix.common.object.PropertyType;
import java.util.List;

public class BasicComponentTypeDefn
extends BasicObject
implements ComponentTypeDefn {
    private ComponentTypeID componentTypeID;
    private ComponentTypePropDefn unModifiablePropertyDefinition;
    private PropertyDefinition propertyDefinition;
    private boolean isDeprecated;
    private boolean effectiveImmediately;

    public BasicComponentTypeDefn(ComponentTypeDefnID id, ComponentTypeID typeID, PropertyDefinition propertyDefinition, boolean deprecated, boolean effectiveImmediately) {
        super(id);
        this.componentTypeID = typeID;
        this.setPropertyDefinition(propertyDefinition);
        this.isDeprecated = deprecated;
        this.effectiveImmediately = effectiveImmediately;
    }

    public BasicComponentTypeDefn(ComponentTypeDefnID id, ComponentTypeID typeID, PropertyDefinition propertyDefinition, boolean deprecated) {
        this(id, typeID, propertyDefinition, deprecated, false);
    }

    BasicComponentTypeDefn(BasicComponentTypeDefn defn) {
        super(defn.getID());
        this.componentTypeID = defn.getComponentTypeID();
        this.isDeprecated = defn.isDeprecated();
        this.effectiveImmediately = defn.isEffectiveImmediately();
        this.setPropertyDefinition(defn.getClonedPropertyDefinition());
    }

    public ComponentTypeID getComponentTypeID() {
        return this.componentTypeID;
    }

    public PropertyDefinition getPropertyDefinition() {
        return this.unModifiablePropertyDefinition;
    }

    public PropertyDefinition getClonedPropertyDefinition() {
        return this.propertyDefinition;
    }

    public PropertyType getPropertyType() {
        return this.propertyDefinition.getPropertyType();
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public boolean isRequired() {
        return this.propertyDefinition.isRequired();
    }

    public boolean isEffectiveImmediately() {
        return this.effectiveImmediately;
    }

    public boolean hasAllowedValues() {
        return this.unModifiablePropertyDefinition.hasAllowedValues();
    }

    public List getAllowedValues() {
        return this.unModifiablePropertyDefinition.getAllowedValues();
    }

    void setComponentTypeID(ComponentTypeID type) {
        this.componentTypeID = type;
    }

    void setIsEffectiveImmediately(boolean effectiveImmediately) {
        this.effectiveImmediately = effectiveImmediately;
    }

    void setIsDeprecated(boolean deprecated) {
        this.isDeprecated = deprecated;
    }

    void setPropertyDefinition(PropertyDefinition propertyDefinition) {
        this.unModifiablePropertyDefinition = new ComponentTypePropDefn(propertyDefinition);
        this.propertyDefinition = propertyDefinition;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        return new BasicComponentTypeDefn(this);
    }
}

