/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.config.model;

import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.model.ConfigurationVisitor;
import com.metamatrix.common.namedobject.BaseID;
import com.metamatrix.common.namedobject.BasicObject;
import com.metamatrix.common.object.PropertiedObject;
import com.metamatrix.core.util.DateUtil;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public abstract class BasicComponentObject
extends BasicObject
implements ComponentObject,
PropertiedObject,
Serializable {
    private ComponentTypeID componentTypeID;
    private String description;
    private String createdBy;
    private String createdDate;
    private Date createdDDate;
    private String lastChangedBy;
    private String lastChangedDate;
    private Date lastChangedDDate;
    private Properties properties = new Properties();

    public BasicComponentObject(BaseID componentID, ComponentTypeID typeID) {
        super(componentID);
        this.componentTypeID = typeID;
    }

    protected BasicComponentObject(BasicComponentObject component) {
        super(component.getID());
        this.setComponentTypeID(component.getComponentTypeID());
        this.setProperties(component.getEditableProperties());
        this.setCreatedBy(component.getCreatedBy());
        this.setCreatedDate(component.getCreatedDateString());
        this.setLastChangedBy(component.getLastChangedBy());
        this.setLastChangedDate(component.getLastChangedDateString());
        this.setDescription(component.getDescription());
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public ComponentTypeID getComponentTypeID() {
        return this.componentTypeID;
    }

    public Properties getProperties() {
        Properties result = new Properties();
        result.putAll((Map<?, ?>)this.properties);
        return result;
    }

    public boolean isDependentUpon(BaseID componentObjectId) {
        return false;
    }

    void setComponentTypeID(ComponentTypeID typeID) {
        this.componentTypeID = typeID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setProperties(Properties properties) {
        Properties p2 = null;
        if (properties != null) {
            Properties properties2 = properties;
            synchronized (properties2) {
                p2 = (Properties)properties.clone();
            }
        } else {
            p2 = new Properties();
        }
        this.properties = p2;
    }

    void addProperty(String name, String value) {
        this.properties.put(name, value);
    }

    void addProperties(Properties newProperties) {
        this.properties.putAll((Map<?, ?>)newProperties);
    }

    void removeProperty(String name) {
        this.properties.remove(name);
    }

    void removeProperties(Collection propertyNames) {
        Iterator it = propertyNames.iterator();
        while (it.hasNext()) {
            this.removeProperty((String)it.next());
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedDate() {
        return this.createdDDate;
    }

    public String getCreatedDateString() {
        return this.createdDate;
    }

    public void setCreatedDate(String createdDate) {
        this.createdDate = createdDate;
        this.createdDDate = BasicComponentObject.convertDate(createdDate);
    }

    public String getLastChangedBy() {
        return this.lastChangedBy;
    }

    public void setLastChangedBy(String lastChangedBy) {
        this.lastChangedBy = lastChangedBy;
    }

    public Date getLastChangedDate() {
        return this.lastChangedDDate;
    }

    public String getLastChangedDateString() {
        return this.lastChangedDate;
    }

    public void setLastChangedDate(String lastChangedDate) {
        this.lastChangedDate = lastChangedDate;
        this.lastChangedDDate = BasicComponentObject.convertDate(lastChangedDate);
    }

    Properties getEditableProperties() {
        return this.properties;
    }

    public String toString() {
        return this.getName();
    }

    private static Date convertDate(String date) {
        Date cd = null;
        if (date == null) {
            return new Date();
        }
        try {
            cd = DateUtil.convertStringToDate(date);
        }
        catch (ParseException e2) {
            try {
                cd = DateFormat.getInstance().parse(date);
            }
            catch (ParseException iae) {
                cd = new Date();
            }
        }
        return cd;
    }

    public void accept(ConfigurationVisitor visitor) {
        visitor.visitComponent(this);
    }
}

