/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.classloader;

import com.metamatrix.common.classloader.NestedException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class ClassLoaderUtil {
    public static boolean debug = false;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static String getClassLoaderInformation(ClassLoader classLoader, String label) {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(byteStream);
        stream.println("START CLASS LOADERS - " + label);
        ClassLoaderUtil.getClassPathRecursively(classLoader, stream);
        stream.println("END CLASS LOADERS - " + label);
        stream.flush();
        return byteStream.toString();
    }

    private static void getClassPathRecursively(ClassLoader classLoader, PrintStream stream) {
        ClassLoaderUtil.getClassPath(classLoader, stream);
        if (classLoader.getParent() != null) {
            ClassLoaderUtil.getClassPathRecursively(classLoader.getParent(), stream);
        }
    }

    private static void getClassPath(ClassLoader classLoader, PrintStream stream) {
        stream.println("ClassLoader: " + classLoader);
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            URL[] urls = urlClassLoader.getURLs();
            for (int i2 = 0; i2 < urls.length; ++i2) {
                stream.println(urls[i2].toString());
            }
        }
    }

    private static void log(String label, String value) {
        if (debug) {
            System.out.println("ClassLoaderUtil " + label + " = " + value);
        }
    }

    public static Object getInstanceInNewClassLoader(String className, String classPath) {
        ClassLoaderUtil.log("className", className);
        ClassLoaderUtil.log("classPath", classPath);
        URLClassLoader classLoader = new URLClassLoader(ClassLoaderUtil.toUrls(classPath), ClassLoaderUtil.getParentClassLoader());
        try {
            Class<?> clazz = classLoader.loadClass(className);
            Object result = clazz.newInstance();
            if (debug) {
                ClassLoaderUtil.log("ClassLoaderUtil.getInstanceInNewClassLoader classLoader information", ClassLoaderUtil.getClassLoaderInformation(result.getClass().getClassLoader(), "object loaded by ClassLoaderUtil.getInstanceInNewClassLoader"));
            }
            return result;
        }
        catch (ClassNotFoundException e2) {
            throw new NestedException(e2);
        }
        catch (InstantiationException e3) {
            throw new NestedException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new NestedException(e4);
        }
    }

    private static ClassLoader getParentClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ClassLoader parent = loader.getParent();
        while (parent != null) {
            loader = parent;
            parent = loader.getParent();
        }
        return loader;
    }

    private static URL[] toUrls(String classPath) {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer tokenizer = new StringTokenizer(classPath, System.getProperty("path.separator"));
        while (tokenizer.hasMoreElements()) {
            String path = tokenizer.nextToken();
            try {
                urls.add(new File(path).toURL());
            }
            catch (MalformedURLException e2) {
                throw new NestedException(e2);
            }
        }
        return urls.toArray(new URL[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readResource(String resourceName) {
        String string;
        block8: {
            StringWriter result = new StringWriter();
            InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
            if (inputStream == null) {
                throw new RuntimeException("Resource not found: " + resourceName);
            }
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(inputStream));
                char[] buffer = new char[1024];
                while (reader.ready()) {
                    int bytesRead = reader.read(buffer);
                    result.write(buffer, 0, bytesRead);
                }
                string = result.toString();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new NestedException(e2);
                }
            }
            reader.close();
        }
        return string;
    }

    public static void printLoadedClasses(ClassLoader classLoader, PrintStream stream) {
        Class<?> classLoaderClass;
        for (classLoaderClass = classLoader.getClass(); classLoaderClass != (class$java$lang$ClassLoader == null ? ClassLoaderUtil.class$("java.lang.ClassLoader") : class$java$lang$ClassLoader); classLoaderClass = classLoaderClass.getSuperclass()) {
        }
        try {
            Field classesField = classLoaderClass.getDeclaredField("classes");
            classesField.setAccessible(true);
            Vector classes = (Vector)classesField.get(classLoader);
            Iterator i2 = classes.iterator();
            while (i2.hasNext()) {
                Class clazz = (Class)i2.next();
                String location = clazz.getProtectionDomain().getCodeSource().getLocation().toString();
                stream.println(location + "\t" + clazz.getName());
            }
        }
        catch (SecurityException e2) {
            throw new NestedException(e2);
        }
        catch (IllegalArgumentException e3) {
            throw new NestedException(e3);
        }
        catch (NoSuchFieldException e4) {
            throw new NestedException(e4);
        }
        catch (IllegalAccessException e5) {
            throw new NestedException(e5);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

