/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.cache.mru;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.cache.ObjectCacheException;
import com.metamatrix.common.cache.ObjectCacheStatistics;
import com.metamatrix.common.cache.policy.AbstractObjectCachePolicy;
import com.metamatrix.common.cache.policy.ObjectCacheHelper;
import com.metamatrix.core.util.ReflectionHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public class MRUObjectCachePolicy
extends AbstractObjectCachePolicy {
    private static final String DEFAULT_MRU_HELPER_CLASS = "com.metamatrix.common.cache.policy.BasicObjectCacheHelper";
    private float recaptureFraction = 0.0f;
    private int maximumCapacity = 0;
    private long maximumCost = 0L;
    private transient long targetCostLevel;
    private transient int targetSizeLevel;
    private Map cache;
    private LinkedList mruList;
    private ObjectCacheStatistics stats;
    private ObjectCacheHelper helper;

    protected MRUObjectCachePolicy(Properties environment) throws ObjectCacheException {
        super(environment);
        Properties env = this.getEnvironment();
        String helperClassName = env.getProperty("com.metamatrix.common.cache.ObjectCache.CacheHelper");
        if (helperClassName == null) {
            helperClassName = DEFAULT_MRU_HELPER_CLASS;
        }
        try {
            this.helper = (ObjectCacheHelper)ReflectionHelper.create(helperClassName, null, this.getClass().getClassLoader());
        }
        catch (Exception e2) {
            throw new ObjectCacheException(e2, "ERR.003.008.0015", CommonPlugin.Util.getString("ERR.003.008.0015", helperClassName == null ? "NullClassName" : helperClassName));
        }
        String value = env.getProperty("com.metamatrix.common.cache.ObjectCache.ResourceRecaptureFraction");
        if (value != null) {
            try {
                this.recaptureFraction = Float.parseFloat(value);
            }
            catch (Exception e3) {
                throw new ObjectCacheException(e3, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureFraction"}));
            }
        } else {
            throw new ObjectCacheException("ERR.003.008.0017", CommonPlugin.Util.getString("ERR.003.008.0017", "com.metamatrix.common.cache.ObjectCache.ResourceRecaptureFraction"));
        }
        if (this.recaptureFraction <= 0.0f || this.recaptureFraction >= 1.0f) {
            throw new ObjectCacheException("ERR.003.008.0018", CommonPlugin.Util.getString("ERR.003.008.0018"));
        }
        value = environment.getProperty("com.metamatrix.common.cache.ObjectCache.MaximumCapacity");
        if (value != null) {
            try {
                this.maximumCapacity = Integer.parseInt(value);
            }
            catch (Exception e4) {
                throw new ObjectCacheException(e4, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.MaximumCapacity"}));
            }
        } else {
            throw new ObjectCacheException("ERR.003.008.0017", CommonPlugin.Util.getString("ERR.003.008.0017", "com.metamatrix.common.cache.ObjectCache.MaximumCapacity"));
        }
        if (this.maximumCapacity < 0) {
            throw new ObjectCacheException("ERR.003.008.0019", CommonPlugin.Util.getString("ERR.003.008.0019"));
        }
        value = environment.getProperty("com.metamatrix.common.cache.ObjectCache.MaximumCost");
        if (value != null) {
            try {
                this.maximumCost = Integer.parseInt(value);
            }
            catch (Exception e5) {
                throw new ObjectCacheException(e5, "ERR.003.008.0016", CommonPlugin.Util.getString("ERR.003.008.0016", new Object[]{value, "com.metamatrix.common.cache.ObjectCache.MaximumCost"}));
            }
        } else {
            throw new ObjectCacheException("ERR.003.008.0017", CommonPlugin.Util.getString("ERR.003.008.0017", "com.metamatrix.common.cache.ObjectCache.MaximumCost"));
        }
        if (this.maximumCost < 0L) {
            throw new ObjectCacheException("ERR.003.008.0020", CommonPlugin.Util.getString("ERR.003.008.0020"));
        }
        float ratio = 1.0f - this.recaptureFraction;
        this.targetCostLevel = (long)((float)this.maximumCost * ratio);
        this.targetSizeLevel = (int)((float)this.maximumCapacity * ratio);
        this.stats = new ObjectCacheStatistics();
        this.cache = new HashMap(this.maximumCapacity);
        this.mruList = new LinkedList();
        this.helper.initialize(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object find(Object key) {
        Object result = null;
        Object valueHolder = null;
        boolean expired = false;
        Object object = this.cache;
        synchronized (object) {
            valueHolder = this.cache.get(key);
            if (valueHolder != null) {
                if (this.helper.isExpired(valueHolder)) {
                    this.cache.remove(key);
                    this.mruList.remove(key);
                    expired = true;
                    result = null;
                } else {
                    this.mruList.remove(key);
                    this.mruList.addFirst(key);
                    result = this.helper.getValueFromHolder(valueHolder);
                }
            }
        }
        if (expired) {
            long cost = this.helper.getValueCost(valueHolder);
            ObjectCacheStatistics objectCacheStatistics = this.stats;
            synchronized (objectCacheStatistics) {
                this.stats.removeEntries(1, cost);
                this.stats.recordCacheAccess(result != null, true);
            }
        }
        object = this.stats;
        synchronized (object) {
            this.stats.recordCacheAccess(result != null, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mark(Object key, Object value) {
        Object valueHolder = null;
        boolean added = false;
        Map map = this.cache;
        synchronized (map) {
            if (this.cache.containsKey(key)) {
                this.mruList.remove(key);
                this.mruList.addFirst(key);
            } else {
                this.mruList.addFirst(key);
                valueHolder = this.helper.getValueHolder(value);
                this.cache.put(key, valueHolder);
                added = true;
            }
        }
        if (added) {
            if (valueHolder == null) {
                valueHolder = this.helper.getValueHolder(value);
            }
            long cost = this.helper.getValueCost(valueHolder);
            ObjectCacheStatistics objectCacheStatistics = this.stats;
            synchronized (objectCacheStatistics) {
                this.stats.addEntries(1, cost);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        Object valueHolder = null;
        Map map = this.cache;
        synchronized (map) {
            valueHolder = this.cache.remove(key);
            this.mruList.remove(key);
        }
        if (valueHolder != null) {
            long cost = this.helper.getValueCost(valueHolder);
            ObjectCacheStatistics objectCacheStatistics = this.stats;
            synchronized (objectCacheStatistics) {
                this.stats.removeEntries(1, cost);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        Map map = this.cache;
        synchronized (map) {
            ObjectCacheStatistics objectCacheStatistics = this.stats;
            synchronized (objectCacheStatistics) {
                this.stats.removeEntries(this.cache.size(), this.stats.getCost());
            }
            this.cache.clear();
            this.mruList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectCacheStatistics getStatistics() {
        ObjectCacheStatistics result = null;
        ObjectCacheStatistics objectCacheStatistics = this.stats;
        synchronized (objectCacheStatistics) {
            result = (ObjectCacheStatistics)this.stats.clone();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object key) {
        boolean result = false;
        Map map = this.cache;
        synchronized (map) {
            result = this.cache.containsKey(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getKeysNotInCache(Collection keys) {
        HashSet result = new HashSet(keys);
        Map map = this.cache;
        synchronized (map) {
            result.removeAll(this.cache.keySet());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getResourceUtilization() {
        float costResult = 0.0f;
        float sizeResult = 0.0f;
        ObjectCacheStatistics objectCacheStatistics = this.stats;
        synchronized (objectCacheStatistics) {
            costResult = this.maximumCost != 0L ? (float)(this.stats.getCost() / this.maximumCost) : 0.0f;
            sizeResult = this.maximumCapacity != 0 ? (float)(this.stats.getSize() / this.maximumCapacity) : 0.0f;
        }
        return sizeResult > costResult ? sizeResult : costResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exceedsResources() {
        float costResult = 0.0f;
        float sizeResult = 0.0f;
        ObjectCacheStatistics objectCacheStatistics = this.stats;
        synchronized (objectCacheStatistics) {
            costResult = this.maximumCost != 0L ? (float)(this.stats.getCost() / this.maximumCost) : 0.0f;
            sizeResult = this.maximumCapacity != 0 ? (float)(this.stats.getSize() / this.maximumCapacity) : 0.0f;
        }
        return costResult > 0.0f || sizeResult > 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduceResourceUsage() {
        int currentSize;
        long currentCost;
        ObjectCacheStatistics objectCacheStatistics = this.stats;
        synchronized (objectCacheStatistics) {
            currentCost = this.stats.getCost();
            currentSize = this.stats.getSize();
        }
        if (currentSize == 0) {
            return;
        }
        long minimumCostReduction = 0L;
        int minimumSizeReduction = 0;
        if (currentCost > this.targetCostLevel) {
            minimumCostReduction = currentCost - this.targetCostLevel;
        }
        if (currentSize > this.targetSizeLevel) {
            minimumSizeReduction = currentSize - this.targetSizeLevel;
        }
        if (minimumCostReduction <= 0L && minimumSizeReduction <= 0) {
            return;
        }
        long adjustedCost = 0L;
        int adjustedSize = 0;
        Object key = null;
        Object valueHolder = null;
        Object object = this.cache;
        synchronized (object) {
            try {
                while (adjustedCost <= minimumCostReduction && adjustedSize <= minimumSizeReduction && adjustedSize < currentSize) {
                    key = this.mruList.removeLast();
                    valueHolder = this.cache.remove(key);
                    if (valueHolder == null) continue;
                    ++adjustedSize;
                    --currentSize;
                    adjustedCost += this.helper.getValueCost(valueHolder);
                }
            }
            catch (NoSuchElementException e2) {
                System.err.println(CommonPlugin.Util.getString("ERR.003.008.0021"));
                e2.printStackTrace(System.err);
            }
        }
        object = this.stats;
        synchronized (object) {
            this.stats.removeEntries(adjustedSize, adjustedCost);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int result = 0;
        Map map = this.cache;
        synchronized (map) {
            result = this.cache.size();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getCopyOfCacheContents() {
        HashMap contents = new HashMap();
        Map map = this.cache;
        synchronized (map) {
            Iterator keyItr = this.cache.keySet().iterator();
            while (keyItr.hasNext()) {
                Object key = keyItr.next();
                contents.put(key, this.cache.get(key));
            }
        }
        return contents;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("  MRU Helper Class:                   ");
        sb.append(this.helper.getClass().getName());
        sb.append("\n");
        sb.append("  Calculator Class:                   ");
        sb.append(this.getEnvironment().getProperty("com.metamatrix.common.cache.ObjectCache.CostCalculatorClass"));
        sb.append("\n");
        return sb.toString();
    }
}

