/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.actions;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.actions.ActionDefinition;
import com.metamatrix.common.actions.AddObject;
import com.metamatrix.common.actions.AttributeDefinition;
import com.metamatrix.common.actions.NamedObjectActionDefinition;

public class AddNamedObject
extends AddObject
implements NamedObjectActionDefinition {
    private static final String SET_DESC = "Set ";

    public AddNamedObject(Object target, AttributeDefinition attribute, String name, Object newValue) {
        super(target, attribute != null ? new Integer(attribute.getCode()) : null, new Object[]{name, newValue});
        if (name == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.004.0003"));
        }
    }

    public AddNamedObject(Object target, AttributeDefinition attribute, Object[] args) {
        super(target, attribute != null ? new Integer(attribute.getCode()) : null, args);
        if (args.length >= 2 && args[args.length - 2] == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.004.0003"));
        }
    }

    protected AddNamedObject(Object target, Integer attributeCode, Object[] args) {
        super(target, attributeCode, args);
    }

    protected AddNamedObject(AddNamedObject rhs) {
        super(rhs);
    }

    public synchronized String getName() {
        return (String)this.getArguments()[0];
    }

    public synchronized Object getNewValue() {
        if (this.getArguments().length > 1) {
            return this.getArguments()[1];
        }
        return "";
    }

    public synchronized void setName(String newName) {
        this.getArguments()[0] = newName;
    }

    public synchronized String getActionDescription() {
        StringBuffer buff = new StringBuffer();
        Object target = this.getTarget();
        String targetClassName = target.getClass().getName();
        String attrDesc = this.getAttributeDescription();
        buff.append(SET_DESC);
        if (attrDesc.length() > 0) {
            buff.append(this.getAttributeDescription() + " \"" + this.getName() + "\" from ");
        }
        buff.append(targetClassName.substring(targetClassName.lastIndexOf(46) + 1) + " " + target.toString());
        return buff.toString();
    }

    public String toString() {
        return this.getActionDescription() + "; new value = " + this.getNewValue();
    }

    public synchronized Object clone() {
        return new AddNamedObject(this);
    }

    public synchronized ActionDefinition getUndoActionDefinition() {
        return new AddNamedObject(this.getTarget(), this.getAttributeCode(), this.getArguments());
    }
}

