/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.actions;

import com.metamatrix.common.CommonPlugin;
import com.metamatrix.common.actions.AddNamedObject;
import com.metamatrix.common.actions.AddObject;
import com.metamatrix.common.actions.AttributeDefinition;
import com.metamatrix.common.actions.CreateObject;
import com.metamatrix.common.actions.DestroyObject;
import com.metamatrix.common.actions.ExchangeBoolean;
import com.metamatrix.common.actions.ExchangeDouble;
import com.metamatrix.common.actions.ExchangeFloat;
import com.metamatrix.common.actions.ExchangeInt;
import com.metamatrix.common.actions.ExchangeLong;
import com.metamatrix.common.actions.ExchangeNamedObject;
import com.metamatrix.common.actions.ExchangeObject;
import com.metamatrix.common.actions.ExchangeShort;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.actions.ObjectEditor;
import com.metamatrix.common.actions.RemoveNamedObject;
import com.metamatrix.common.actions.RemoveObject;
import java.io.Serializable;

public class AbstractObjectEditor
implements ObjectEditor,
Serializable {
    protected static final int FIRST_COMMAND = 0;
    protected static final int LAST_COMMAND = 2;
    protected static final String SET_LBL = "Set";
    protected static final String ADD_LBL = "Add";
    protected static final String REMOVE_LBL = "Remove";
    private static final String[] LABELS = new String[]{"Set", "Add", "Remove"};
    private ModificationActionQueue destination = null;
    private boolean createActions = false;

    public AbstractObjectEditor() {
    }

    public AbstractObjectEditor(boolean createActions) {
        this.createActions = createActions;
    }

    public ModificationActionQueue getDestination() {
        return this.destination;
    }

    public void setDestination(ModificationActionQueue destination) {
        this.destination = destination;
    }

    public boolean doCreateActions() {
        return this.createActions;
    }

    public void setCreateActions(boolean doCreateActions) {
        this.createActions = doCreateActions;
    }

    protected String getLabel(int command) {
        return command <= 2 ? LABELS[command] : "<unknown command>";
    }

    protected void verifyCommand(int command) {
        if (command < 0 || command > 2) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.004.0001", String.valueOf(command)));
        }
    }

    protected Object verifyTargetClass(Object target, Class requiredClass) throws IllegalArgumentException {
        if (!requiredClass.isInstance(target)) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.004.0002", new Object[]{target.getClass().getName(), requiredClass.getName()}));
        }
        return target;
    }

    protected void createCreationAction(Object targetId, Object value) {
        if (this.createActions) {
            CreateObject action = new CreateObject(targetId, value);
            this.getDestination().addAction(action);
        }
    }

    protected void createAddNamedAction(Object targetId, AttributeDefinition attrDefn, String name, Object value) {
        if (this.createActions) {
            AddNamedObject action = new AddNamedObject(targetId, attrDefn, name, value);
            this.getDestination().addAction(action);
        }
    }

    protected void createAddAction(Object targetId, AttributeDefinition attrDefn, Object value) {
        if (this.createActions) {
            AddObject action = new AddObject(targetId, attrDefn, value);
            this.getDestination().addAction(action);
        }
    }

    protected void createExchangeNamedAction(Object targetId, AttributeDefinition attrDefn, String name, Object oldValue, Object newValue) {
        if (this.createActions) {
            ExchangeNamedObject action = new ExchangeNamedObject(targetId, attrDefn, name, oldValue, newValue);
            this.getDestination().addAction(action);
        }
    }

    protected void createExchangeAction(Object targetId, AttributeDefinition attrDefn, Object oldValue, Object newValue) {
        if (this.createActions) {
            ExchangeObject action = new ExchangeObject(targetId, attrDefn, oldValue, newValue);
            this.getDestination().addAction(action);
        }
    }

    protected void createRemoveNamedAction(Object targetId, AttributeDefinition attrDefn, String name, Object oldValue) {
        if (this.createActions) {
            RemoveNamedObject action = new RemoveNamedObject(targetId, attrDefn, name, oldValue);
            this.getDestination().addAction(action);
        }
    }

    protected void createRemoveAction(Object targetId, AttributeDefinition attriDefn, Object oldValue) {
        if (this.createActions) {
            RemoveObject action = new RemoveObject(targetId, attriDefn, oldValue);
            this.getDestination().addAction(action);
        }
    }

    protected void createExchangeBoolean(Object targetId, AttributeDefinition attrDefn, boolean oldValue, boolean newValue) {
        if (this.createActions) {
            ExchangeBoolean action = new ExchangeBoolean(targetId, attrDefn, oldValue, newValue);
            this.getDestination().addAction(action);
        }
    }

    protected void createExchangeInt(Object targetId, AttributeDefinition attrDefn, int oldValue, int newValue) {
        if (this.createActions) {
            ExchangeInt action = new ExchangeInt(targetId, attrDefn, oldValue, newValue);
            this.getDestination().addAction(action);
        }
    }

    protected void createExchangeLong(Object targetId, AttributeDefinition attrDefn, long oldValue, long newValue) {
        if (this.createActions) {
            ExchangeLong action = new ExchangeLong(targetId, attrDefn, oldValue, newValue);
            this.getDestination().addAction(action);
        }
    }

    protected void createExchangeDouble(Object targetId, AttributeDefinition attrDefn, double oldValue, double newValue) {
        if (this.createActions) {
            ExchangeDouble action = new ExchangeDouble(targetId, attrDefn, oldValue, newValue);
            this.getDestination().addAction(action);
        }
    }

    protected void createExchangeFloat(Object targetId, AttributeDefinition attrDefn, float oldValue, float newValue) {
        if (this.createActions) {
            ExchangeFloat action = new ExchangeFloat(targetId, attrDefn, oldValue, newValue);
            this.getDestination().addAction(action);
        }
    }

    protected void createExchangeShort(Object targetId, AttributeDefinition attrDefn, short oldValue, short newValue) {
        if (this.createActions) {
            ExchangeShort action = new ExchangeShort(targetId, attrDefn, oldValue, newValue);
            this.getDestination().addAction(action);
        }
    }

    protected void createDestroyAction(Object targetId, Object targetObject) {
        if (this.createActions) {
            DestroyObject action = new DestroyObject(targetId, targetObject);
            this.getDestination().addAction(action);
        }
    }
}

