/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.api.exception;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.api.exception.MetaMatrixRuntimeException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MetaMatrixExceptionUtil {
    private static final Iterator EMPTY_ITERATOR = new Iterator(){

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    private MetaMatrixExceptionUtil() {
    }

    public static Iterator getChildrenIterator(Throwable e2) {
        if (e2 instanceof MetaMatrixException) {
            return new NestedExceptionIterator((MetaMatrixException)e2);
        }
        if (e2 instanceof MetaMatrixRuntimeException) {
            return new NestedExceptionIterator((MetaMatrixRuntimeException)e2);
        }
        return EMPTY_ITERATOR;
    }

    public static String getLinkedMessages(Throwable exception, int level, MessageFormatter messageFormatter) {
        if (exception != null) {
            StringBuffer buf = new StringBuffer();
            buf.append(messageFormatter.getFormattedMessage(exception, level));
            Iterator children = MetaMatrixExceptionUtil.getChildrenIterator(exception);
            while (children.hasNext()) {
                exception = (Throwable)children.next();
                buf.append(messageFormatter.getFormattedMessage(exception, ++level));
            }
            return buf.toString();
        }
        return "";
    }

    public static class NestedExceptionIterator
    implements Iterator {
        Throwable exception;
        Throwable child;

        NestedExceptionIterator(MetaMatrixException e2) {
            this.exception = e2;
        }

        NestedExceptionIterator(MetaMatrixRuntimeException e2) {
            this.exception = e2;
        }

        public boolean hasNext() {
            this.check();
            return this.child != null;
        }

        public Object next() {
            this.check();
            if (this.child == null) {
                throw new NoSuchElementException();
            }
            this.exception = this.child;
            this.child = null;
            return this.exception;
        }

        private void check() {
            if (this.child == null) {
                if (this.exception instanceof MetaMatrixException) {
                    MetaMatrixException e2 = (MetaMatrixException)this.exception;
                    this.child = e2.getChild();
                } else if (this.exception instanceof MetaMatrixRuntimeException) {
                    MetaMatrixRuntimeException e3 = (MetaMatrixRuntimeException)this.exception;
                    this.child = e3.getChild();
                }
            }
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface MessageFormatter {
        public String getFormattedMessage(Throwable var1, int var2);
    }
}

