/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.api.core.message;

import com.metamatrix.api.core.message.ProgressMonitor;
import com.metamatrix.api.core.message.ProgressMonitorListener;
import com.metamatrix.common.CommonPlugin;

public class DefaultProgressMonitor
implements ProgressMonitor {
    public static final boolean DEFAULT_CANCEL_SUPPORTED = false;
    private static final long NO_TIME = 0L;
    private final String description;
    private final boolean cancelSupported;
    private boolean cancelled;
    private String currentTaskName;
    private long currentTaskWorkTotal;
    private long currentTaskWork;
    private long startTime;
    private long stopTime;
    private int totSecs;
    private ProgressMonitorListener listener;
    private boolean remainingSupported;

    public DefaultProgressMonitor(String description) {
        this(description, false);
    }

    public DefaultProgressMonitor(String description, boolean cancelSupported) {
        if (description == null) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("DefaultProgressMonitor.description_null"));
        }
        this.description = description;
        this.cancelSupported = cancelSupported;
        this.cancelled = false;
        this.startTime = 0L;
        this.stopTime = 0L;
    }

    public void setTaskName(String taskName) {
        this.currentTaskName = taskName;
        if (this.listener != null) {
            this.listener.taskNameChanged();
        }
    }

    public void setTotalWork(long totalWork) {
        if (totalWork < 1L && totalWork != Long.MAX_VALUE) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.003.0006"));
        }
        this.currentTaskWorkTotal = totalWork;
        this.currentTaskWork = 0L;
    }

    public void setTaskName(String taskName, long totalWork) {
        this.setTaskName(taskName);
        this.setTotalWork(totalWork);
    }

    public synchronized void start() {
        this.startTime = System.currentTimeMillis();
    }

    public synchronized void addWork(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.003.0007"));
        }
        if (!this.isStarted()) {
            this.start();
        }
        if (this.currentTaskWork != this.currentTaskWorkTotal) {
            this.currentTaskWork += value;
            this.calculateTotalWorkSeconds();
            this.checkComplete();
        }
    }

    public synchronized void setWork(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(CommonPlugin.Util.getString("ERR.003.003.0008"));
        }
        if (!this.isStarted()) {
            this.start();
        }
        if (this.currentTaskWork != this.currentTaskWorkTotal) {
            this.currentTaskWork = value;
            this.calculateTotalWorkSeconds();
            this.checkComplete();
        }
    }

    protected void calculateTotalWorkSeconds() {
        if (!this.isStarted()) {
            return;
        }
        if (this.currentTaskWorkTotal == Long.MAX_VALUE) {
            return;
        }
        if (this.currentTaskWork == 0L) {
            return;
        }
        double factor = (double)this.currentTaskWorkTotal / (double)this.currentTaskWork;
        long msElapsed = System.currentTimeMillis() - this.startTime;
        long msRemaining = (long)((double)msElapsed * factor);
        this.totSecs = (int)(msRemaining / 1000L);
    }

    protected synchronized boolean checkComplete() {
        if (this.currentTaskWork >= this.currentTaskWorkTotal) {
            this.currentTaskWork = this.currentTaskWorkTotal;
            return true;
        }
        return false;
    }

    public synchronized void setComplete() {
        this.currentTaskWork = this.currentTaskWorkTotal;
        this.stopTime = System.currentTimeMillis();
    }

    public String getDescription() {
        return this.description;
    }

    public String getTaskName() {
        return this.currentTaskName;
    }

    public int getSecondsElapsed() {
        if (this.isStarted()) {
            long delta = System.currentTimeMillis() - this.startTime;
            return (int)(delta / 1000L);
        }
        return 0;
    }

    public int getSecondsRemaining() {
        if (!this.remainingSupported) {
            return -1;
        }
        int secs = this.totSecs - this.getSecondsElapsed();
        if (secs < 0) {
            this.calculateTotalWorkSeconds();
            secs = this.totSecs - this.getSecondsElapsed();
        }
        return secs;
    }

    public boolean getSecondsRemainingSupported() {
        return this.remainingSupported;
    }

    public void setSecondsRemainingSupported(boolean supported) {
        this.remainingSupported = supported;
    }

    public long getWork() {
        return this.currentTaskWork;
    }

    public long getTotalWork() {
        return this.currentTaskWorkTotal;
    }

    public int getProgress() {
        if (!this.isStarted()) {
            return 0;
        }
        if (this.currentTaskWorkTotal == Long.MAX_VALUE) {
            if (this.currentTaskWork == this.currentTaskWorkTotal) {
                return 100;
            }
            if (this.currentTaskWork == 0L) {
                return 0;
            }
            int remainder = (int)(this.currentTaskWork % 100L);
            return remainder == 0 ? 100 : remainder;
        }
        if (this.currentTaskWork == this.currentTaskWorkTotal || this.stopTime != 0L) {
            return 100;
        }
        if (this.currentTaskWork > this.currentTaskWorkTotal) {
            return 99;
        }
        double fraction = (double)this.currentTaskWork / (double)this.currentTaskWorkTotal;
        if (fraction < 0.99) {
            return (int)(fraction * 100.0);
        }
        return 99;
    }

    public boolean isComplete() {
        return this.stopTime != 0L;
    }

    public boolean isStarted() {
        return this.startTime != 0L;
    }

    public boolean isCancelSupported() {
        return this.cancelSupported;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public ProgressMonitorListener getProgressMonitorListener() {
        return this.listener;
    }

    public void setProgressMonitorListener(ProgressMonitorListener listener) {
        this.listener = listener;
    }
}

