/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.api.core.message;

import com.metamatrix.api.core.message.DefaultProgressMonitor;
import com.metamatrix.api.core.message.InputStreamProgressMonitor;
import com.metamatrix.common.CommonPlugin;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class CancellableInputStreamProgressMonitor
extends InputStreamProgressMonitor {
    private static final long BYTES_BETWEEN_CANCEL_CHECKS = 4096L;
    private long bytesBeforeNextCancelCheck = 4096L;

    public CancellableInputStreamProgressMonitor(InputStream stream, DefaultProgressMonitor monitor) {
        super(stream, monitor);
    }

    public CancellableInputStreamProgressMonitor(InputStream stream, DefaultProgressMonitor monitor, boolean completeOnEOS) {
        super(stream, monitor, completeOnEOS);
    }

    protected void addWorkToMonitor(long bytes) throws IOException {
        this.bytesBeforeNextCancelCheck -= bytes;
        if (this.bytesBeforeNextCancelCheck < 0L) {
            if (super.getProgressMonitor().isCancelled()) {
                String taskName = super.getProgressMonitor().getTaskName();
                if (taskName != null && taskName.trim().length() != 0) {
                    throw new InterruptedIOException(CommonPlugin.Util.getString("ERR.003.003.0001", taskName));
                }
                String desc = super.getProgressMonitor().getDescription();
                if (desc != null && desc.trim().length() != 0) {
                    throw new InterruptedIOException(CommonPlugin.Util.getString("ERR.003.003.0001", desc));
                }
                throw new InterruptedIOException(CommonPlugin.Util.getString("ERR.003.003.0002"));
            }
            this.bytesBeforeNextCancelCheck = 4096L;
        }
        super.addWorkToMonitor(bytes);
    }
}

