/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import java.io.Serializable;

public class Fraction
implements Cloneable,
Comparable,
Serializable {
    protected final long numerator_;
    protected final long denominator_;

    public final long numerator() {
        return this.numerator_;
    }

    public final long denominator() {
        return this.denominator_;
    }

    public Fraction(long l2, long l3) {
        boolean bl = l2 >= 0L;
        boolean bl2 = l3 >= 0L;
        long l4 = bl ? l2 : -l2;
        long l5 = bl2 ? l3 : -l3;
        long l6 = Fraction.gcd(l4, l5);
        this.numerator_ = bl == bl2 ? l4 / l6 : -l4 / l6;
        this.denominator_ = l5 / l6;
    }

    public Fraction(Fraction fraction) {
        this.numerator_ = fraction.numerator();
        this.denominator_ = fraction.denominator();
    }

    public String toString() {
        if (this.denominator() == 1L) {
            return "" + this.numerator();
        }
        return this.numerator() + "/" + this.denominator();
    }

    public Object clone() {
        return new Fraction(this);
    }

    public double asDouble() {
        return (double)this.numerator() / (double)this.denominator();
    }

    public static long gcd(long l2, long l3) {
        long l4;
        long l5;
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (l3 < 0L) {
            l3 = -l3;
        }
        if (l2 >= l3) {
            l5 = l2;
            l4 = l3;
        } else {
            l5 = l3;
            l4 = l2;
        }
        while (l4 != 0L) {
            long l6 = l5 % l4;
            l5 = l4;
            l4 = l6;
        }
        return l5;
    }

    public Fraction negative() {
        long l2 = this.numerator();
        long l3 = this.denominator();
        return new Fraction(-l2, l3);
    }

    public Fraction inverse() {
        long l2 = this.numerator();
        long l3 = this.denominator();
        return new Fraction(l3, l2);
    }

    public Fraction plus(Fraction fraction) {
        long l2 = this.numerator();
        long l3 = this.denominator();
        long l4 = fraction.numerator();
        long l5 = fraction.denominator();
        return new Fraction(l2 * l5 + l4 * l3, l3 * l5);
    }

    public Fraction plus(long l2) {
        long l3 = this.numerator();
        long l4 = this.denominator();
        long l5 = l2;
        long l6 = 1L;
        return new Fraction(l3 * l6 + l5 * l4, l4 * l6);
    }

    public Fraction minus(Fraction fraction) {
        long l2 = this.numerator();
        long l3 = this.denominator();
        long l4 = fraction.numerator();
        long l5 = fraction.denominator();
        return new Fraction(l2 * l5 - l4 * l3, l3 * l5);
    }

    public Fraction minus(long l2) {
        long l3 = this.numerator();
        long l4 = this.denominator();
        long l5 = l2;
        long l6 = 1L;
        return new Fraction(l3 * l6 - l5 * l4, l4 * l6);
    }

    public Fraction times(Fraction fraction) {
        long l2 = this.numerator();
        long l3 = this.denominator();
        long l4 = fraction.numerator();
        long l5 = fraction.denominator();
        return new Fraction(l2 * l4, l3 * l5);
    }

    public Fraction times(long l2) {
        long l3 = this.numerator();
        long l4 = this.denominator();
        long l5 = l2;
        long l6 = 1L;
        return new Fraction(l3 * l5, l4 * l6);
    }

    public Fraction dividedBy(Fraction fraction) {
        long l2 = this.numerator();
        long l3 = this.denominator();
        long l4 = fraction.numerator();
        long l5 = fraction.denominator();
        return new Fraction(l2 * l5, l3 * l4);
    }

    public Fraction dividedBy(long l2) {
        long l3 = this.numerator();
        long l4 = this.denominator();
        long l5 = l2;
        long l6 = 1L;
        return new Fraction(l3 * l6, l4 * l5);
    }

    public int compareTo(Object object) {
        long l2;
        Fraction fraction = (Fraction)object;
        long l3 = this.numerator();
        long l4 = this.denominator();
        long l5 = fraction.numerator();
        long l6 = fraction.denominator();
        long l7 = l3 * l6;
        return l7 < (l2 = l5 * l4) ? -1 : (l7 == l2 ? 0 : 1);
    }

    public int compareTo(long l2) {
        long l3;
        long l4;
        long l5;
        long l6;
        long l7 = this.numerator();
        long l8 = l7 * (l6 = 1L);
        return l8 < (l5 = (l4 = l2) * (l3 = this.denominator())) ? -1 : (l8 == l5 ? 0 : 1);
    }

    public boolean equals(Object object) {
        return this.compareTo((Fraction)object) == 0;
    }

    public boolean equals(long l2) {
        return this.compareTo(l2) == 0;
    }

    public int hashCode() {
        return (int)(this.numerator_ ^ this.denominator_);
    }
}

