/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Barrier;
import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.TimeoutException;
import EDU.oswego.cs.dl.util.concurrent.WaiterPreferenceSemaphore;

public class Rendezvous
implements Barrier {
    protected final int parties_;
    protected boolean broken_ = false;
    protected int entries_ = 0;
    protected long departures_ = 0L;
    protected final Semaphore entryGate_;
    protected final Object[] slots_;
    protected RendezvousFunction rendezvousFunction_;

    public Rendezvous(int n2) {
        this(n2, new Rotator());
    }

    public Rendezvous(int n2, RendezvousFunction rendezvousFunction) {
        if (n2 <= 0) {
            throw new IllegalArgumentException();
        }
        this.parties_ = n2;
        this.rendezvousFunction_ = rendezvousFunction;
        this.entryGate_ = new WaiterPreferenceSemaphore(n2);
        this.slots_ = new Object[n2];
    }

    public synchronized RendezvousFunction setRendezvousFunction(RendezvousFunction rendezvousFunction) {
        RendezvousFunction rendezvousFunction2 = this.rendezvousFunction_;
        this.rendezvousFunction_ = rendezvousFunction;
        return rendezvousFunction2;
    }

    public int parties() {
        return this.parties_;
    }

    public synchronized boolean broken() {
        return this.broken_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        while (true) {
            Rendezvous rendezvous = this;
            synchronized (rendezvous) {
                if (this.entries_ == 0) {
                    this.broken_ = false;
                    return;
                }
                this.notifyAll();
            }
            Thread.yield();
        }
    }

    public Object rendezvous(Object object) throws InterruptedException, BrokenBarrierException {
        return this.doRendezvous(object, false, 0L);
    }

    public Object attemptRendezvous(Object object, long l2) throws InterruptedException, TimeoutException, BrokenBarrierException {
        return this.doRendezvous(object, true, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doRendezvous(Object object, boolean bl, long l2) throws InterruptedException, TimeoutException, BrokenBarrierException {
        long l3;
        if (bl) {
            l3 = System.currentTimeMillis();
            if (!this.entryGate_.attempt(l2)) {
                throw new TimeoutException(l2);
            }
        } else {
            l3 = 0L;
            this.entryGate_.acquire();
        }
        Rendezvous rendezvous = this;
        synchronized (rendezvous) {
            Object object2 = null;
            int n2 = this.entries_++;
            this.slots_[n2] = object;
            try {
                if (this.entries_ == this.parties_) {
                    this.departures_ = this.entries_;
                    this.notifyAll();
                    try {
                        if (!this.broken_ && this.rendezvousFunction_ != null) {
                            this.rendezvousFunction_.rendezvousFunction(this.slots_);
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        this.broken_ = true;
                    }
                } else {
                    while (!this.broken_ && this.departures_ < 1L) {
                        long l4 = 0L;
                        if (bl && (l4 = l2 - (System.currentTimeMillis() - l3)) <= 0L) {
                            this.broken_ = true;
                            this.departures_ = this.entries_;
                            this.notifyAll();
                            throw new TimeoutException(l2);
                        }
                        try {
                            this.wait(l4);
                        }
                        catch (InterruptedException interruptedException) {
                            if (this.broken_ || this.departures_ > 0L) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                            this.broken_ = true;
                            this.departures_ = this.entries_;
                            this.notifyAll();
                            throw interruptedException;
                        }
                    }
                }
                Object var14_11 = null;
            }
            catch (Throwable throwable) {
                Object var14_12 = null;
                object2 = this.slots_[n2];
                if (--this.departures_ <= 0L) {
                    for (int i2 = 0; i2 < this.slots_.length; ++i2) {
                        this.slots_[i2] = null;
                    }
                    this.entryGate_.release(this.entries_);
                    this.entries_ = 0;
                }
                throw throwable;
            }
            object2 = this.slots_[n2];
            if (--this.departures_ <= 0L) {
                for (int i3 = 0; i3 < this.slots_.length; ++i3) {
                    this.slots_[i3] = null;
                }
                this.entryGate_.release(this.entries_);
                this.entries_ = 0;
            }
            if (this.broken_) {
                throw new BrokenBarrierException(n2);
            }
            return object2;
        }
    }

    public static class Rotator
    implements RendezvousFunction {
        public void rendezvousFunction(Object[] objectArray) {
            int n2 = objectArray.length - 1;
            Object object = objectArray[0];
            for (int i2 = 0; i2 < n2; ++i2) {
                objectArray[i2] = objectArray[i2 + 1];
            }
            objectArray[n2] = object;
        }
    }

    public static interface RendezvousFunction {
        public void rendezvousFunction(Object[] var1);
    }
}

