/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;

public abstract class QueuedSemaphore
extends Semaphore {
    protected final WaitQueue wq_;

    QueuedSemaphore(WaitQueue waitQueue, long l2) {
        super(l2);
        this.wq_ = waitQueue;
    }

    public void acquire() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.precheck()) {
            return;
        }
        WaitQueue.WaitNode waitNode = new WaitQueue.WaitNode();
        waitNode.doWait(this);
    }

    public boolean attempt(long l2) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.precheck()) {
            return true;
        }
        if (l2 <= 0L) {
            return false;
        }
        WaitQueue.WaitNode waitNode = new WaitQueue.WaitNode();
        return waitNode.doTimedWait(this, l2);
    }

    protected synchronized boolean precheck() {
        boolean bl;
        boolean bl2 = bl = this.permits_ > 0L;
        if (bl) {
            --this.permits_;
        }
        return bl;
    }

    protected synchronized boolean recheck(WaitQueue.WaitNode waitNode) {
        boolean bl;
        boolean bl2 = bl = this.permits_ > 0L;
        if (bl) {
            --this.permits_;
        } else {
            this.wq_.insert(waitNode);
        }
        return bl;
    }

    protected synchronized WaitQueue.WaitNode getSignallee() {
        WaitQueue.WaitNode waitNode = this.wq_.extract();
        if (waitNode == null) {
            ++this.permits_;
        }
        return waitNode;
    }

    public void release() {
        WaitQueue.WaitNode waitNode;
        do {
            if ((waitNode = this.getSignallee()) != null) continue;
            return;
        } while (!waitNode.signal());
    }

    public void release(long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative argument");
        }
        for (long i2 = 0L; i2 < l2; ++i2) {
            this.release();
        }
    }

    protected static abstract class WaitQueue {
        protected WaitQueue() {
        }

        protected abstract void insert(WaitNode var1);

        protected abstract WaitNode extract();

        protected static class WaitNode {
            boolean waiting = true;
            WaitNode next = null;

            protected WaitNode() {
            }

            protected synchronized boolean signal() {
                boolean bl = this.waiting;
                if (bl) {
                    this.waiting = false;
                    this.notify();
                }
                return bl;
            }

            protected synchronized boolean doTimedWait(QueuedSemaphore queuedSemaphore, long l2) throws InterruptedException {
                if (queuedSemaphore.recheck(this) || !this.waiting) {
                    return true;
                }
                if (l2 <= 0L) {
                    this.waiting = false;
                    return false;
                }
                long l3 = l2;
                long l4 = System.currentTimeMillis();
                try {
                    do {
                        this.wait(l3);
                        if (this.waiting) continue;
                        return true;
                    } while ((l3 = l2 - (System.currentTimeMillis() - l4)) > 0L);
                    this.waiting = false;
                    return false;
                }
                catch (InterruptedException interruptedException) {
                    if (this.waiting) {
                        this.waiting = false;
                        throw interruptedException;
                    }
                    Thread.currentThread().interrupt();
                    return true;
                }
            }

            protected synchronized void doWait(QueuedSemaphore queuedSemaphore) throws InterruptedException {
                if (!queuedSemaphore.recheck(this)) {
                    try {
                        while (this.waiting) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (this.waiting) {
                            this.waiting = false;
                            throw interruptedException;
                        }
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }
    }
}

