/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.tns;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.oracle.tns.TnsDescription;
import com.metamatrix.jdbc.oracle.tns.TnsValueInfo;
import java.sql.SQLException;
import java.util.ArrayList;

public class TnsDescriptionList {
    private static String footprint = "$Revision:   1.2.2.0  $";
    private boolean m_failover = true;
    private boolean m_loadBalance = true;
    private boolean m_sourceRoute = false;
    private ArrayList m_descriptorList = new ArrayList();

    static TnsDescriptionList Create(String string, String string2, BaseExceptions baseExceptions) throws SQLException {
        TnsDescriptionList tnsDescriptionList = null;
        TnsValueInfo tnsValueInfo = new TnsValueInfo(string2);
        if (tnsValueInfo.Equals("DESCRIPTION_LIST")) {
            tnsDescriptionList = new TnsDescriptionList(tnsValueInfo);
        } else if (tnsValueInfo.Equals("DESCRIPTION")) {
            TnsDescription tnsDescription = new TnsDescription(tnsValueInfo);
            tnsDescriptionList = new TnsDescriptionList(tnsDescription);
        } else {
            String[] stringArray = new String[]{string};
            throw baseExceptions.getException(7024, stringArray, "08001");
        }
        return tnsDescriptionList;
    }

    TnsDescriptionList(TnsDescription tnsDescription) {
        this.m_descriptorList.add(tnsDescription);
    }

    TnsDescriptionList(TnsValueInfo tnsValueInfo) {
        ArrayList arrayList = tnsValueInfo.getValues();
        int n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            TnsValueInfo tnsValueInfo2 = new TnsValueInfo((String)arrayList.get(n2));
            if (tnsValueInfo2.Equals("DESCRIPTION")) {
                TnsDescription tnsDescription = new TnsDescription(tnsValueInfo2);
                this.m_descriptorList.add(tnsDescription);
            } else if (tnsValueInfo2.Equals("FAILOVER")) {
                this.m_failover = tnsValueInfo2.getBoolValue();
            } else if (tnsValueInfo2.Equals("LOAD_BALANCE")) {
                this.m_loadBalance = tnsValueInfo2.getBoolValue();
            } else if (tnsValueInfo2.Equals("SOURCE_ROUTE")) {
                this.m_sourceRoute = tnsValueInfo2.getBoolValue();
            }
            ++n2;
        }
    }

    public boolean getFailover() {
        return this.m_failover;
    }

    public boolean getLoadBalance() {
        return this.m_loadBalance;
    }

    public ArrayList getDescriptorList() {
        return this.m_descriptorList;
    }

    public boolean getSourceRoute() {
        return this.m_sourceRoute;
    }

    public void CollectConnectDescriptors(int n, ArrayList arrayList, String string, BaseExceptions baseExceptions) throws SQLException {
        String[] stringArray;
        if (this.m_sourceRoute) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (this.m_loadBalance) {
            n2 = n % this.m_descriptorList.size();
        }
        int n4 = n2;
        do {
            stringArray = (String[])this.m_descriptorList.get(n4);
            int n5 = arrayList.size();
            stringArray.CollectConnectDescriptors(n, arrayList);
            if (!this.m_failover && n5 != arrayList.size()) break;
            if (n4 + 1 == this.m_descriptorList.size()) {
                n4 = 0;
                continue;
            }
            ++n4;
        } while (++n3 < this.m_descriptorList.size());
        if (arrayList.size() == 0) {
            stringArray = new String[]{string};
            throw baseExceptions.getException(7024, stringArray, "08001");
        }
    }
}

