/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseData;
import java.util.HashMap;

public class BaseColumns {
    private static String footprint = "$Revision:   3.6.2.1  $";
    static final int INITIAL_SIZE = 16;
    private BaseColumn[] columns = new BaseColumn[16];
    private int nextEmptyPosition = 0;
    public static final int COUNT_ALL = 0;
    public static final int COUNT_EXPOSED = 1;
    public static final int COUNT_HIDDEN = 2;
    public static final int COUNT_KEY = 3;
    public static final int COUNT_AUTOINCREMENT = 4;
    private boolean countsValid = false;
    private int hiddenCount;
    private int exposedCount;
    private int allCount;
    private int keyCount;
    private int autoincrementCount;
    private HashMap columnLabelMap;
    private HashMap columnNameMap;

    public void add(BaseColumn baseColumn) {
        if (this.nextEmptyPosition == this.columns.length - 1) {
            BaseColumn[] baseColumnArray = this.columns;
            this.columns = new BaseColumn[this.columns.length * 2];
            System.arraycopy(baseColumnArray, 0, this.columns, 0, baseColumnArray.length);
        }
        this.columns[this.nextEmptyPosition++] = baseColumn;
        this.countsValid = false;
    }

    public int count(int n) {
        if (!this.countsValid) {
            this.calculateCounts();
        }
        switch (n) {
            case 0: {
                return this.allCount;
            }
            case 1: {
                return this.exposedCount;
            }
            case 2: {
                return this.hiddenCount;
            }
            case 3: {
                return this.keyCount;
            }
            case 4: {
                return this.autoincrementCount;
            }
        }
        return 0;
    }

    private void calculateCounts() {
        this.allCount = this.nextEmptyPosition;
        this.hiddenCount = 0;
        this.exposedCount = 0;
        this.keyCount = 0;
        this.autoincrementCount = 0;
        int n = 0;
        while (n < this.allCount) {
            BaseColumn baseColumn = this.columns[n];
            if (baseColumn.isHidden) {
                ++this.hiddenCount;
            } else {
                ++this.exposedCount;
            }
            if (baseColumn.isKey) {
                ++this.keyCount;
            }
            if (baseColumn.isAutoIncrement && !baseColumn.isHidden) {
                ++this.autoincrementCount;
            }
            ++n;
        }
        this.countsValid = true;
    }

    public BaseColumn get(int n) {
        BaseColumn baseColumn = this.columns[n - 1];
        return baseColumn;
    }

    public boolean isValidColumnOrdinal(int n) {
        if (!this.countsValid) {
            this.calculateCounts();
        }
        return n > 0 && n <= this.exposedCount;
    }

    public int getOrdinal(String string) {
        int n = this.nextEmptyPosition;
        if (this.columnLabelMap == null) {
            this.columnLabelMap = new HashMap(n);
        } else {
            Object v = this.columnLabelMap.get(string);
            if (v != null) {
                return (Integer)v;
            }
        }
        int n2 = 0;
        while (n2 < n) {
            if (this.columns[n2].name.equalsIgnoreCase(string)) {
                this.columnLabelMap.put(string, new Integer(n2 + 1));
                return n2 + 1;
            }
            ++n2;
        }
        if (this.columnNameMap == null) {
            this.columnNameMap = new HashMap(n);
        } else {
            Object v = this.columnNameMap.get(string);
            if (v != null) {
                return (Integer)v;
            }
        }
        int n3 = 0;
        while (n3 < n) {
            if (this.columns[n3].name.equalsIgnoreCase(string)) {
                this.columnNameMap.put(string, new Integer(n3 + 1));
                return n3 + 1;
            }
            ++n3;
        }
        return 0;
    }

    public void reset() {
        if (this.columns != null) {
            this.nextEmptyPosition = 0;
        }
        this.countsValid = false;
    }

    public void resetCount() {
        this.countsValid = false;
    }

    public void markColumnsAsKeyStartingAt(int n, boolean bl) {
        this.allCount = this.nextEmptyPosition;
        int n2 = n - 1;
        while (n2 < this.allCount) {
            BaseColumn baseColumn = this.columns[n2];
            if (!(baseColumn.isSearchable != 4 && baseColumn.isSearchable != 3 || baseColumn.isHidden || BaseData.isStreamed(baseColumn.baseDataType))) {
                baseColumn.isKey = true;
            }
            if (bl) {
                baseColumn.isHidden = true;
            }
            ++n2;
        }
        this.countsValid = false;
    }
}

