/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell.database;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionCommandImpl;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class StatusCommand
extends DatabaseConnectionCommandImpl {
    private static final String STATUS_PREFIX_MESSAGE = ToolsPlugin.Util.getString("StatusCommand.status_prefix");

    public boolean executeCommand(Iterator argIter) {
        String url = ToolsPlugin.Util.getString("StatusCommand.not_available");
        String driver = ToolsPlugin.Util.getString("StatusCommand.not_available");
        String connectedStatus = ToolsPlugin.Util.getString("StatusCommand.not_available");
        String autocommit = ToolsPlugin.Util.getString("StatusCommand.not_available");
        String maxrows = ToolsPlugin.Util.getString("StatusCommand.not_available");
        String queryTimeout = ToolsPlugin.Util.getString("StatusCommand.not_available");
        DatabaseConnectionContext dcContext = this.getDatabaseConnectionContext();
        try {
            Connection connection = dcContext.getConnection();
            url = dcContext.getURL();
            driver = dcContext.getDriver();
            if (connection.isClosed()) {
                connectedStatus = ToolsPlugin.Util.getString("StatusCommand.no");
            } else {
                connectedStatus = ToolsPlugin.Util.getString("StatusCommand.yes");
                autocommit = "" + connection.getAutoCommit();
                if (dcContext.getMaxRows() != -1) {
                    maxrows = "" + dcContext.getMaxRows();
                }
                if (dcContext.getQueryTimeout() != -1) {
                    queryTimeout = "" + dcContext.getQueryTimeout();
                }
            }
        }
        catch (SQLException sqle) {
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        String LF = this.toolShell.getSystemLineSeparator();
        this.printlnVerbose(STATUS_PREFIX_MESSAGE);
        this.printlnVerbose(ToolsPlugin.Util.getString("StatusCommand.url") + url + LF + ToolsPlugin.Util.getString("StatusCommand.driver") + driver + LF + ToolsPlugin.Util.getString("StatusCommand.connected") + connectedStatus + LF + LF + ToolsPlugin.Util.getString("StatusCommand.auto_commit") + autocommit + LF + ToolsPlugin.Util.getString("StatusCommand.max_rows") + maxrows + LF + ToolsPlugin.Util.getString("StatusCommand.query_timeout") + queryTimeout + LF);
        return true;
    }

    public String getCommandName() {
        return ToolsPlugin.Util.getString("StatusCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return ToolsPlugin.Util.getString("StatusCommand.longHelp");
    }

    public String getShortHelp() {
        return ToolsPlugin.Util.getString("StatusCommand.shortHelp");
    }

    public String getArgHelp() {
        return ToolsPlugin.Util.getString("StatusCommand.argHelp");
    }
}

