/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell.database;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionCommandImpl;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class QueryTimeoutCommand
extends DatabaseConnectionCommandImpl {
    private static final String MISSING_ARGUMENT_ERROR_STRING = ToolsPlugin.Util.getString("QueryTimeoutCommand.error_missing_seconds_to_timeout");

    public boolean executeCommand(Iterator argIter) {
        DatabaseConnectionContext dcContext = this.getDatabaseConnectionContext();
        try {
            Connection connection = dcContext.getConnection();
            if (!argIter.hasNext()) {
                throw new IllegalArgumentException(MISSING_ARGUMENT_ERROR_STRING);
            }
            if (connection == null) {
                this.printlnError(NOT_CONNECTED_ERROR_STRING);
                return true;
            }
            String secondsString = (String)argIter.next();
            int seconds = Integer.parseInt(secondsString);
            dcContext.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            this.printlnSQLException(e);
        }
        catch (ClassNotFoundException e) {
            this.printlnException(e);
        }
        return true;
    }

    public String getCommandName() {
        return ToolsPlugin.Util.getString("QueryTimeoutCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return ToolsPlugin.Util.getString("QueryTimeoutCommand.longHelp");
    }

    public String getShortHelp() {
        return ToolsPlugin.Util.getString("QueryTimeoutCommand.shortHelp");
    }

    public String getArgHelp() {
        return ToolsPlugin.Util.getString("QueryTimeoutCommand.argHelp");
    }
}

