/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell.database;

import com.metamatrix.tools.toolshell.CommandContext;
import com.metamatrix.tools.toolshell.ToolShell;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseConnectionContext
implements CommandContext {
    private Connection connection;
    private Statement statement;
    private String url;
    private String driver;
    private int queryTimeout = -1;
    private int maxRows = -1;
    private int fetchSize = -1;
    private String vdbName = "";
    private boolean useLazyConnections = false;
    private ToolShell toolShell;
    private String dqpProperties;

    public Connection getConnection() throws SQLException, ClassNotFoundException {
        if (this.useLazyConnections && this.connection == null) {
            this.createConnection();
        }
        return this.connection;
    }

    public Statement getStatement() throws SQLException {
        this.closeStatement();
        this.statement = this.connection.createStatement();
        if (this.queryTimeout != -1) {
            this.statement.setQueryTimeout(this.queryTimeout);
        }
        if (this.maxRows != -1) {
            this.statement.setMaxRows(this.maxRows);
        }
        if (this.fetchSize != -1) {
            this.statement.setFetchSize(this.fetchSize);
        }
        return this.statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatement() {
        try {
            if (this.statement != null) {
                this.statement.close();
            }
        }
        catch (SQLException e) {
            this.toolShell.printlnSQLException(e);
        }
        finally {
            this.statement = null;
        }
    }

    public void createConnection() throws SQLException, ClassNotFoundException {
        try {
            this.closeConnection();
            Class.forName(this.driver);
            this.connection = DriverManager.getConnection(this.url);
        }
        catch (SQLException e) {
            this.toolShell.printlnSQLException(e);
            throw e;
        }
        catch (ClassNotFoundException e) {
            this.toolShell.printlnException(e);
            throw e;
        }
    }

    private void initializeVDBNameFromMetaData() {
        String schemaName = "";
        try {
            if (this.connection != null) {
                ResultSet result = this.connection.getMetaData().getSchemas();
                if (result != null) {
                    while (result.next()) {
                        schemaName = result.getString(1);
                    }
                }
                this.setVDBName(schemaName);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        if (this.connection != null) {
            this.closeStatement();
            this.queryTimeout = -1;
            this.maxRows = -1;
            this.fetchSize = -1;
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                this.toolShell.printlnSQLException(e);
            }
            finally {
                this.connection = null;
            }
            this.vdbName = "";
        }
    }

    public String getDriver() {
        return this.driver;
    }

    public String getURL() {
        return this.url;
    }

    public void setDriver(String string) {
        this.driver = string;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public void setQueryTimeout(int secs) {
        this.queryTimeout = secs;
    }

    public void setMaxRows(int rows) {
        this.maxRows = rows;
    }

    public void setFetchSize(int size) {
        this.fetchSize = size;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public String getVDBName() {
        if (this.vdbName == null || this.vdbName.length() == 0) {
            this.initializeVDBNameFromMetaData();
        }
        return this.vdbName;
    }

    private void setVDBName(String vdbName) {
        this.vdbName = vdbName;
    }

    public boolean getUseLazyConnections() {
        return this.useLazyConnections;
    }

    public void setUseLazyConnections(boolean useLazyConnections) {
        this.useLazyConnections = useLazyConnections;
    }

    public void setToolShell(ToolShell toolShell) {
        this.toolShell = toolShell;
    }

    public String getDqpProperties() {
        return this.dqpProperties;
    }

    public void setDqpProperties(String properties) {
        this.dqpProperties = properties;
    }

    public void close() {
        try {
            this.closeStatement();
            this.closeConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

