/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.Command;
import com.metamatrix.tools.toolshell.Stopwatch;
import com.metamatrix.tools.toolshell.ToolShell;
import com.metamatrix.tools.toolshell.parser.BlockCommand;
import com.metamatrix.tools.toolshell.parser.CommandProcessor;
import java.util.List;

public class ToolShellCommandProcessor
implements CommandProcessor {
    private ToolShell shell;
    private boolean interactive;
    private boolean printElapsed;
    private boolean inBlock = false;
    private Stopwatch stopwatch = new Stopwatch();

    public ToolShellCommandProcessor(ToolShell toolShell, boolean interactive, boolean printElapsed) {
        this.shell = toolShell;
        this.interactive = interactive;
        this.printElapsed = printElapsed;
    }

    protected ToolShell getShell() {
        return this.shell;
    }

    public void startProcessing() {
        if (this.interactive) {
            this.shell.printPrompt();
        }
    }

    public boolean wasBlockCommand() {
        if (this.inBlock) {
            this.inBlock = false;
            return true;
        }
        return false;
    }

    public boolean isCommandComplete(List commandWords) throws Exception {
        if (commandWords.size() == 0) {
            return false;
        }
        if (((String)commandWords.get(commandWords.size() - 1)).equalsIgnoreCase("END")) {
            return true;
        }
        Command command = this.shell.findCommand(commandWords);
        if (command instanceof BlockCommand) {
            this.inBlock = true;
            return true;
        }
        this.inBlock = false;
        if (command.isComplete(commandWords)) {
            return true;
        }
        if (this.interactive) {
            this.shell.printContinuationPrompt(false);
        }
        return false;
    }

    public boolean processCommand(List commandWords) {
        if (commandWords.size() == 0) {
            this.shell.printPrompt();
            return true;
        }
        boolean running = true;
        Command commandFromFile = null;
        try {
            commandFromFile = this.shell.findCommand(commandWords);
            this.shell.logCommand(commandWords);
            this.stopwatch.start();
            if (this.interactive) {
                this.shell.printlnVerbose("");
            }
            running = commandFromFile.executeCommand(commandWords.iterator());
            this.stopwatch.stop();
            if (this.printElapsed && running) {
                this.shell.printlnVerbose(ToolsPlugin.Util.getString("ToolShell.elapsed_time", this.stopwatch.getElapsedTime()));
            }
        }
        catch (Throwable t) {
            this.shell.printlnException(t);
        }
        if (running) {
            this.shell.printPrompt();
        }
        return running;
    }

    public void readCommandInBlock(List commandWords) {
        if (this.interactive) {
            this.shell.printContinuationPrompt(true);
        }
    }
}

