/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.Stopwatch;
import com.metamatrix.tools.toolshell.ToolCommandImpl;
import java.util.Iterator;
import java.util.List;

public class TimerCommand
extends ToolCommandImpl {
    private static final String START = ToolsPlugin.Util.getString("TimerCommand.command_start");
    private static final String ELAPSED = ToolsPlugin.Util.getString("TimerCommand.command_elapsed");
    private Stopwatch stopwatch = new Stopwatch();
    private static final String MISSING_ARGUMENT_ERROR_STRING = ToolsPlugin.Util.getString("TimerCommand.missing_argument");
    private static final String ILLEGAL_ARGUMENT_ERROR_STRING = ToolsPlugin.Util.getString("TimerCommand.illegal_argument");

    public boolean executeCommand(Iterator argIter) {
        argIter.next();
        if (!argIter.hasNext()) {
            throw new IllegalArgumentException(MISSING_ARGUMENT_ERROR_STRING);
        }
        String timerCommand = (String)argIter.next();
        if (timerCommand.toLowerCase().trim().equals(START)) {
            this.stopwatch.start();
        } else if (timerCommand.toLowerCase().trim().equals(ELAPSED)) {
            long timeElapsed = this.stopwatch.getElapsedTime();
            this.printlnError(ToolsPlugin.Util.getString("TimerCommand.elapsed_time", timeElapsed));
        } else {
            throw new IllegalArgumentException(ILLEGAL_ARGUMENT_ERROR_STRING + timerCommand);
        }
        return true;
    }

    public String getCommandName() {
        return ToolsPlugin.Util.getString("TimerCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return ToolsPlugin.Util.getString("TimerCommand.longHelp");
    }

    public String getShortHelp() {
        return ToolsPlugin.Util.getString("TimerCommand.shortHelp");
    }

    public String getArgHelp() {
        return ToolsPlugin.Util.getString("TimerCommand.argHelp");
    }
}

