/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.Command;
import com.metamatrix.tools.toolshell.ExitCommand;
import com.metamatrix.tools.toolshell.ToolCommandImpl;
import com.metamatrix.tools.toolshell.ToolShell;
import com.metamatrix.tools.toolshell.ToolShellCommandProcessor;
import com.metamatrix.tools.toolshell.parser.CommandIterator;
import com.metamatrix.tools.toolshell.parser.CommandLoop;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;

public class ScriptFileCommand
extends ToolCommandImpl {
    private static final String ILLEGAL_ARGUMENT_STRING = ToolsPlugin.Util.getString("ScriptFileCommand.error_missing_filename");
    public static final String SCRIPT_COMMAND_STRING = ToolsPlugin.Util.getString("ScriptFileCommand.commandName");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeCommand(Iterator argIter) {
        InputStreamReader fileReader = null;
        try {
            argIter.next();
            if (!argIter.hasNext()) {
                throw new IllegalArgumentException(ILLEGAL_ARGUMENT_STRING);
            }
            String filename = (String)argIter.next();
            File f = new File(filename);
            fileReader = new FileReader(f);
            CommandIterator iter = this.toolShell.createCommandIterator(fileReader);
            ScriptFileCommandProcessor processor = new ScriptFileCommandProcessor(this.toolShell, false, false);
            CommandLoop loop = new CommandLoop(iter, processor, true);
            loop.process();
        }
        catch (IOException e) {
            this.printlnException(e);
        }
        finally {
            try {
                fileReader.close();
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public String getCommandName() {
        return SCRIPT_COMMAND_STRING;
    }

    public String getLongHelp(List argList) {
        return ToolsPlugin.Util.getString("ScriptFileCommand.longHelp", (Object)"';'", (Object)"'#'");
    }

    public String getShortHelp() {
        return ToolsPlugin.Util.getString("ScriptFileCommand.shortHelp");
    }

    public String getArgHelp() {
        return ToolsPlugin.Util.getString("ScriptFileCommand.argHelp");
    }

    private static class ScriptFileCommandProcessor
    extends ToolShellCommandProcessor {
        public ScriptFileCommandProcessor(ToolShell toolShell, boolean interactive, boolean printElapsed) {
            super(toolShell, interactive, printElapsed);
        }

        public boolean processCommand(List commandWords) {
            try {
                Command command = this.getShell().findCommand(commandWords);
                if (command instanceof ExitCommand) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return super.processCommand(commandWords);
        }
    }
}

