/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.toolshell;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.Command;
import com.metamatrix.tools.toolshell.Stopwatch;
import com.metamatrix.tools.toolshell.ToolCommandImpl;
import com.metamatrix.tools.toolshell.parser.BlockCommand;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class RepeatCommand
extends ToolCommandImpl
implements BlockCommand {
    private static final String MISSING_ARGUMENT_ERROR_STRING = ToolsPlugin.Util.getString("RepeatCommand.missing_times_to_repeat");
    private static final String NUMBER_FORMAT_ERROR_STRING = ToolsPlugin.Util.getString("RepeatCommand.error_invalid_integer");

    public boolean isComplete(List commandWords) {
        return commandWords.size() >= 2;
    }

    private boolean runStatements(List commands, int timesToRepeat) {
        Stopwatch stopwatch = new Stopwatch();
        boolean running = true;
        String LF = this.toolShell.getSystemLineSeparator();
        for (int i = 0; i < timesToRepeat; ++i) {
            this.printlnVerbose(ToolsPlugin.Util.getString("RepeatCommand.repeat_counter", i));
            Iterator commandsIterator = commands.iterator();
            while (running && commandsIterator.hasNext()) {
                List words = (List)commandsIterator.next();
                this.printlnVerbose(StringUtil.join((List)words, (String)" ") + LF);
                try {
                    Command commandFromFile = this.toolShell.findCommand(words);
                    stopwatch.start();
                    running = commandFromFile.executeCommand(words.iterator());
                    stopwatch.stop();
                    if (!running) continue;
                    this.printlnVerbose(ToolsPlugin.Util.getString("RepeatCommand.elapsed_time", stopwatch.getElapsedTime()));
                }
                catch (Throwable t) {
                    this.printlnException(t);
                }
            }
        }
        return true;
    }

    public boolean executeCommand(Iterator argIter) {
        argIter.next();
        if (!argIter.hasNext()) {
            throw new IllegalArgumentException(MISSING_ARGUMENT_ERROR_STRING);
        }
        int timesToRepeat = 1;
        try {
            timesToRepeat = Integer.parseInt((String)argIter.next());
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(NUMBER_FORMAT_ERROR_STRING);
        }
        if (timesToRepeat <= 0) {
            return true;
        }
        ArrayList commands = new ArrayList();
        ArrayList<String> currentCommand = null;
        while (argIter.hasNext()) {
            String word = (String)argIter.next();
            if (word.equalsIgnoreCase("END")) {
                if (currentCommand == null) break;
                commands.add(currentCommand);
                break;
            }
            if (word.equalsIgnoreCase("||||")) {
                if (currentCommand != null && currentCommand.size() > 0) {
                    commands.add(currentCommand);
                }
                currentCommand = null;
                continue;
            }
            if (currentCommand == null) {
                currentCommand = new ArrayList<String>();
            }
            currentCommand.add(word);
        }
        return this.runStatements(commands, timesToRepeat);
    }

    public String getCommandName() {
        return ToolsPlugin.Util.getString("RepeatCommand.commandName");
    }

    public String getLongHelp(List argList) {
        return ToolsPlugin.Util.getString("RepeatCommand.longHelp");
    }

    public String getShortHelp() {
        return ToolsPlugin.Util.getString("RepeatCommand.shortHelp", (Object)";");
    }

    public String getArgHelp() {
        return ToolsPlugin.Util.getString("RepeatCommand.argHelp");
    }
}

