/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.tools.jdbcisql;

import com.metamatrix.tools.ToolsPlugin;
import com.metamatrix.tools.toolshell.BadCommand;
import com.metamatrix.tools.toolshell.BlankCommand;
import com.metamatrix.tools.toolshell.CommentCommand;
import com.metamatrix.tools.toolshell.EchoCommand;
import com.metamatrix.tools.toolshell.ExitCommand;
import com.metamatrix.tools.toolshell.HelpCommand;
import com.metamatrix.tools.toolshell.RepeatCommand;
import com.metamatrix.tools.toolshell.ScriptFileCommand;
import com.metamatrix.tools.toolshell.TimerCommand;
import com.metamatrix.tools.toolshell.ToolShell;
import com.metamatrix.tools.toolshell.WaitCommand;
import com.metamatrix.tools.toolshell.database.AutocommitCommand;
import com.metamatrix.tools.toolshell.database.CommitCommand;
import com.metamatrix.tools.toolshell.database.ConnectCommand;
import com.metamatrix.tools.toolshell.database.DatabaseConnectionContext;
import com.metamatrix.tools.toolshell.database.DisconnectCommand;
import com.metamatrix.tools.toolshell.database.ExecCommand;
import com.metamatrix.tools.toolshell.database.FetchCommand;
import com.metamatrix.tools.toolshell.database.MaxrowsCommand;
import com.metamatrix.tools.toolshell.database.QueryTimeoutCommand;
import com.metamatrix.tools.toolshell.database.RollbackCommand;
import com.metamatrix.tools.toolshell.database.SqlDeleteCommand;
import com.metamatrix.tools.toolshell.database.SqlInsertCommand;
import com.metamatrix.tools.toolshell.database.SqlSelectCommand;
import com.metamatrix.tools.toolshell.database.SqlUpdateCommand;
import com.metamatrix.tools.toolshell.database.StatusCommand;
import com.metamatrix.tools.toolshell.database.XqueryCommand;
import com.metamatrix.tools.toolshell.log.Logger;
import com.metamatrix.tools.toolshell.log.ShellLogger;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;

public class JDBCisql
extends ToolShell {
    public static void main(String[] args) throws Exception {
        ArgReader reader = new ArgReader(args);
        if (reader.showHelp()) {
            JDBCisql.printUsage();
            System.exit(0);
        }
        JDBCisql jdbcisql = new JDBCisql();
        Logger shellLogger = new Logger();
        jdbcisql.setVerbosity(reader.getVerbosity());
        shellLogger.addDestination(ShellLogger.DEST.STDOUT, System.out);
        shellLogger.addDestination(ShellLogger.DEST.STDERR, System.err);
        jdbcisql.setLogger(shellLogger);
        jdbcisql.setInteractive(reader.getScriptFile() == null);
        DatabaseConnectionContext dcContext = jdbcisql.getDatabaseConnectionContext();
        dcContext.setToolShell(jdbcisql);
        dcContext.setUseLazyConnections(false);
        jdbcisql.initializeCommands();
        if (reader.getScriptFile() == null) {
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            jdbcisql.acceptCommands(inputStreamReader, true);
        } else {
            jdbcisql.runCommandFile(reader.getScriptFile());
        }
    }

    private static void printUsage() {
        System.out.println(ToolsPlugin.Util.getString("JDBCisql.usage"));
    }

    protected void initializeCommandList() {
        ExitCommand exitCommand = new ExitCommand();
        this.putCommand(exitCommand);
        this.commands.put(ExitCommand.QUIT_COMMAND_STRING, exitCommand);
        this.commands.put(ExitCommand.BYE_COMMAND_STRING, exitCommand);
        this.putCommand(new CommentCommand());
        this.putCommand(new EchoCommand());
        this.putCommand(new ExecCommand());
        this.putCommand(new FetchCommand());
        this.putCommand(new MaxrowsCommand());
        this.putCommand(new QueryTimeoutCommand());
        this.putCommand(new TimerCommand());
        this.putCommand(new WaitCommand());
        this.putCommand(new BlankCommand());
        this.putCommand(new BadCommand());
        this.putCommand(new HelpCommand());
        this.putCommand(new SqlSelectCommand());
        this.putCommand(new SqlInsertCommand());
        this.putCommand(new SqlUpdateCommand());
        this.putCommand(new SqlDeleteCommand());
        this.putCommand(new DisconnectCommand());
        this.putCommand(new ConnectCommand());
        this.putCommand(new CommitCommand());
        this.putCommand(new RepeatCommand());
        this.putCommand(new RollbackCommand());
        this.putCommand(new AutocommitCommand());
        this.putCommand(new ScriptFileCommand());
        this.putCommand(new StatusCommand());
        this.putCommand(new XqueryCommand());
    }

    protected String getPrompt() {
        DatabaseConnectionContext dcContext = this.getDatabaseConnectionContext();
        return dcContext.getVDBName();
    }

    public char getCommentChar() {
        return '#';
    }

    public char getEndOfCommandChar() {
        return '\n';
    }

    static class ArgReader {
        private static final char OPTION_PREFIX = '-';
        private static final String DEBUG = "-debug";
        private static final String QUIET = "-quiet";
        private static final String VERBOSE = "-verbose";
        private static final String SCRIPT = "-script";
        String scriptFile = null;
        boolean requestedHelp = false;
        int verbosity = 2;

        public ArgReader(String[] args) throws Exception {
            LinkedList<String> argList = new LinkedList<String>(Arrays.asList(args));
            if (argList.size() == 0) {
                return;
            }
            if (this.inHelpMode(argList)) {
                this.requestedHelp = true;
                return;
            }
            while (argList.size() > 0) {
                String option = argList.getFirst();
                if (option.charAt(0) == '-') {
                    if (option.equalsIgnoreCase(QUIET)) {
                        this.verbosity = 1;
                        argList.removeFirst();
                        continue;
                    }
                    if (option.equalsIgnoreCase(VERBOSE)) {
                        argList.removeFirst();
                        continue;
                    }
                    if (option.equalsIgnoreCase(DEBUG)) {
                        this.verbosity = 3;
                        argList.removeFirst();
                        continue;
                    }
                    if (option.equalsIgnoreCase(SCRIPT)) {
                        argList.removeFirst();
                        if (argList.size() == 0) {
                            throw new Exception(ToolsPlugin.Util.getString("ArgReader.script_requires_file"));
                        }
                        this.scriptFile = argList.removeFirst();
                        continue;
                    }
                    throw new Exception(ToolsPlugin.Util.getString("ArgReader.invalid_option", (Object)option));
                }
                throw new Exception(ToolsPlugin.Util.getString("ArgReader.invalid_option", (Object)option));
            }
        }

        private boolean inHelpMode(LinkedList argList) {
            if (argList.size() == 1) {
                String possibleHelp = (String)argList.get(0);
                return ToolShell.isHelpSynonym(possibleHelp);
            }
            return false;
        }

        public String getScriptFile() {
            return this.scriptFile;
        }

        public int getVerbosity() {
            return this.verbosity;
        }

        public boolean showHelp() {
            return this.requestedHelp;
        }
    }
}

