/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.relational;

import com.metamatrix.core.plugin.PluginUtilities;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.core.util.PluginUtilImpl;
import com.metamatrix.metamodels.relational.util.RelationalTypeMapping;
import com.metamatrix.metamodels.relational.util.RelationalTypeMappingImpl;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.internal.jdbc.relational.JdbcNodeToRelationalMappingImpl;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.relational.JdbcNodeToRelationalMapping;
import com.metamatrix.modeler.jdbc.relational.ModelerJdbcRelationalConstants;
import com.metamatrix.modeler.jdbc.relational.RelationalModelProcessor;
import com.metamatrix.modeler.jdbc.relational.impl.RelationalModelProcessorImpl;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.BundleContext;

public class JdbcRelationalPlugin
extends Plugin
implements com.metamatrix.modeler.internal.jdbc.relational.ModelerJdbcRelationalConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$jdbc$relational$JdbcRelationalPlugin == null ? (class$com$metamatrix$modeler$jdbc$relational$JdbcRelationalPlugin = JdbcRelationalPlugin.class$("com.metamatrix.modeler.jdbc.relational.JdbcRelationalPlugin")) : class$com$metamatrix$modeler$jdbc$relational$JdbcRelationalPlugin));
    public static boolean DEBUG = false;
    public static boolean CREATE_MODEL_IN_TRANSACTION = true;
    private static final JdbcNodeToRelationalMapping JDBC_TO_RELATIONAL_MAPPING = new JdbcNodeToRelationalMappingImpl();
    private static final String MODEL_CONTAINER_NAME = JdbcRelationalPlugin.getString("modelContainerName");
    public static final String DELIMITER = ".";
    private static JdbcRelationalPlugin plugin;
    private static Container modelCtnr;
    static /* synthetic */ Class class$com$metamatrix$modeler$jdbc$relational$JdbcRelationalPlugin;

    public static JdbcRelationalPlugin getDefault() {
        return plugin;
    }

    public static Container getModelContainer() throws CoreException {
        if (modelCtnr == null) {
            modelCtnr = ModelerCore.createContainer((String)MODEL_CONTAINER_NAME);
        }
        return modelCtnr;
    }

    private static String getString(String id) {
        return com.metamatrix.modeler.internal.jdbc.relational.ModelerJdbcRelationalConstants.Util.getString(I18N_PREFIX + id);
    }

    public JdbcRelationalPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ((PluginUtilImpl)com.metamatrix.modeler.internal.jdbc.relational.ModelerJdbcRelationalConstants.Util).initializePlatformLogger((Plugin)this);
    }

    public void stop(BundleContext context) throws Exception {
        if (modelCtnr != null) {
            modelCtnr.shutdown();
        }
        super.stop(context);
    }

    public static RelationalModelProcessor createRelationalModelProcessor(JdbcSource source) {
        return JdbcRelationalPlugin.createRelationalModelProcessor(source, RelationalTypeMappingImpl.getInstance());
    }

    public static RelationalModelProcessor createRelationalModelProcessor(JdbcSource source, RelationalTypeMapping mapping) {
        String driverClassName;
        RelationalModelProcessor processor = null;
        if (source != null && (driverClassName = source.getDriverClass()) != null) {
            IExtension[] extensions = PluginUtilities.getExtensions((String)EXTENSION_POINT.MODEL_PROCESSOR.UNIQUE_ID);
            for (int i = 0; i < extensions.length; ++i) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elems = extension.getConfigurationElements();
                boolean driverMatches = false;
                Object instance = null;
                for (int j = 0; j < elems.length; ++j) {
                    String className;
                    IConfigurationElement elem = elems[j];
                    String elemName = elem.getName();
                    if (elemName == null) continue;
                    if (elemName.equals("driverClass") && driverClassName.equals(className = elem.getAttribute("name"))) {
                        driverMatches = true;
                    }
                    if (!elemName.equals("processorClass")) continue;
                    String attribName = "name";
                    try {
                        instance = elem.createExecutableExtension("name");
                        continue;
                    }
                    catch (Throwable e) {
                        com.metamatrix.modeler.internal.jdbc.relational.ModelerJdbcRelationalConstants.Util.log(e);
                    }
                }
                if (!driverMatches || instance == null || !(instance instanceof RelationalModelProcessor)) continue;
                processor = (RelationalModelProcessor)instance;
                break;
            }
        }
        if (processor == null) {
            processor = new RelationalModelProcessorImpl();
        }
        if (mapping != null && processor != null && processor instanceof RelationalModelProcessorImpl) {
            processor.setTypeMapping(mapping);
        }
        return processor;
    }

    public static JdbcNodeToRelationalMapping getJdbcNodeToRelationalMapping() {
        return JDBC_TO_RELATIONAL_MAPPING;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class EXTENSION_POINT {

        public static class MODEL_PROCESSOR {
            public static final String ID = "modelProcessor";
            public static final String UNIQUE_ID = ModelerJdbcRelationalConstants.PLUGIN_ID + "." + "modelProcessor";

            public static class ATTRIBUTES {
                public static final String NAME = "name";
            }

            public static class ELEMENTS {
                public static final String DRIVER_CLASS_NAME = "driverClass";
                public static final String PROCESSOR_CLASS = "processorClass";
            }
        }
    }
}

