/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.metadata.impl;

import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.data.Request;

public class RequestContainer {
    private final Request[] requests;
    private String[] requestNames;

    public RequestContainer(Request[] requests) {
        this.requests = requests != null ? requests : new Request[]{};
    }

    public synchronized String[] getNamesOfResults() throws JdbcException {
        if (this.requestNames == null) {
            String[] names = new String[this.requests.length];
            for (int i = 0; i < this.requests.length; ++i) {
                Request request = this.requests[i];
                names[i] = request.getName();
            }
            this.requestNames = names;
        }
        return this.requestNames;
    }

    public Request getRequest(String name) throws JdbcException {
        return this.getRequest(name, true);
    }

    public Request getRequest(String name, boolean includeMetadata) throws JdbcException {
        for (int i = 0; i < this.requests.length; ++i) {
            Request request = this.requests[i];
            if (!request.getName().equals(name)) continue;
            if (!request.hasResults() && !request.hasProblems()) {
                request.setMetadataRequested(includeMetadata);
                request.invoke();
            }
            return request;
        }
        return null;
    }
}

