/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.data;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.internal.jdbc.JdbcUtil;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.data.Request;
import com.metamatrix.modeler.jdbc.data.ResultsMetadata;
import com.metamatrix.modeler.jdbc.data.TupleValidator;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;

public class Response {
    private static final int NUM_COLUMNS_NOT_SET = -1;
    private final Request request;
    private final List records;
    private int numColumns;
    private ResultsMetadata metadata;

    public Response(Request request) {
        ArgCheck.isNotNull((Object)request);
        this.request = request;
        this.records = new LinkedList();
        this.numColumns = -1;
        this.metadata = null;
    }

    public ResultsMetadata getMetadata() {
        return this.metadata;
    }

    protected void setResultsMetadata(ResultsMetadata metadata) {
        this.metadata = metadata;
    }

    public void addRecord(List record) {
        if (this.numColumns == -1) {
            this.numColumns = record.size();
        } else {
            ArgCheck.isTrue((record.size() == this.numColumns ? 1 : 0) != 0, (String)JdbcPlugin.Util.getString("Response.Add_error_column_count_mismatch", (Object)record, (Object)new Integer(this.numColumns)));
        }
        this.records.add(record);
    }

    public List getRecords() {
        return this.records;
    }

    public int getColumnCount() {
        return this.numColumns;
    }

    public Request getRequest() {
        return this.request;
    }

    public static void addResults(Response results, ResultSet resultSet, boolean addMetadata) throws SQLException {
        Response.addResults(results, resultSet, addMetadata, null);
    }

    public static void addResults(Response results, ResultSet resultSet, boolean addMetadata, TupleValidator validator) throws SQLException {
        SQLWarning warning;
        ResultSetMetaData metadata = resultSet.getMetaData();
        int numColumns = metadata.getColumnCount();
        while (resultSet.next()) {
            ArrayList<Object> tuple = new ArrayList<Object>(numColumns);
            for (int i = 1; i <= numColumns; ++i) {
                Object cell = resultSet.getObject(i);
                tuple.add(cell);
            }
            if (validator != null && !validator.isTupleValid(tuple)) continue;
            results.addRecord(tuple);
        }
        if (addMetadata) {
            try {
                ResultsMetadata resultsMetadata = ResultsMetadata.create(metadata);
                results.setResultsMetadata(resultsMetadata);
            }
            catch (SQLException e) {
                IStatus error = JdbcUtil.createIStatus(e);
                if (error != null) {
                    results.getRequest().addProblems(Collections.singletonList(error));
                }
                JdbcPlugin.Util.log((Throwable)e);
            }
        }
        if ((warning = resultSet.getWarnings()) != null) {
            ArrayList<IStatus> warnings = new ArrayList<IStatus>();
            while (warning != null) {
                warnings.add(JdbcUtil.createIStatus(warning));
                warning = warning.getNextWarning();
            }
            if (warnings.size() != 0) {
                results.getRequest().addProblems(warnings);
            }
        }
    }

    public static void addResults(Response results, Object result, boolean addMetadata) {
        ArrayList<Object> tuple = new ArrayList<Object>(1);
        tuple.add(result);
        results.addRecord(tuple);
        if (addMetadata) {
            ResultsMetadata metadata = new ResultsMetadata();
            results.setResultsMetadata(metadata);
        }
    }
}

