/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.data;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.internal.jdbc.JdbcUtil;
import com.metamatrix.modeler.internal.jdbc.data.ResultsImpl;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.data.Response;
import com.metamatrix.modeler.jdbc.data.Results;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public abstract class Request {
    private Results results;
    private Response response;
    private IStatus problems;
    private final String name;
    private final Object target;
    private boolean metadataRequested = true;

    public Request(String name, Object target) {
        ArgCheck.isNotNull((Object)target);
        this.target = target;
        this.name = name;
    }

    public Object getTarget() {
        return this.target;
    }

    public final boolean invoke() {
        Response tempResponse = new Response(this);
        this.problems = this.performInvocation(tempResponse);
        this.response = tempResponse;
        this.results = new ResultsImpl(this.response);
        return this.problems == null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    protected abstract IStatus performInvocation(Response var1);

    protected boolean hasResponse() {
        return this.response != null;
    }

    protected Response getResponse() {
        return this.response;
    }

    public Results getResults() {
        return this.results;
    }

    public boolean hasResults() {
        return this.results != null;
    }

    public boolean hasProblems() {
        return this.problems != null;
    }

    public IStatus getProblems() {
        return this.problems;
    }

    public void addProblems(List istatuses) {
        if (istatuses == null || istatuses.isEmpty()) {
            return;
        }
        if (this.problems == null) {
            if (istatuses.size() == 1) {
                this.problems = (IStatus)istatuses.get(0);
            }
            if (istatuses.size() > 1) {
                String text = JdbcPlugin.Util.getString("Request.Request.MultipleProblems");
                this.problems = JdbcUtil.createIStatus(istatuses, text);
            }
        } else if (this.problems instanceof MultiStatus) {
            MultiStatus multiStatus = (MultiStatus)this.problems;
            String text = JdbcPlugin.Util.getString("Request.Request.MultipleProblems");
            IStatus newProblems = JdbcUtil.createIStatus(istatuses, text);
            multiStatus.addAll(newProblems);
            this.problems = multiStatus;
        } else {
            istatuses.add(0, this.problems);
            String text = JdbcPlugin.Util.getString("Request.Request.MultipleProblems");
            this.problems = JdbcUtil.createIStatus(istatuses, text);
        }
    }

    public void clear() {
        this.response = null;
        this.problems = null;
        this.results = null;
    }

    public boolean isMetadataRequested() {
        return this.metadataRequested;
    }

    public void setMetadataRequested(boolean metadataRequested) {
        this.metadataRequested = metadataRequested;
    }
}

