/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.jdbc.custom;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.custom.ExcelDatabaseMetaDataHandler;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;

public class ExcelConnectionHandler
implements InvocationHandler {
    private Connection connection;
    private File excelFile;
    static /* synthetic */ Class class$java$sql$DatabaseMetaData;

    public ExcelConnectionHandler(Connection connection, String url) {
        ArgCheck.isNotNull((Object)connection);
        ArgCheck.isNotNull((Object)url);
        this.connection = connection;
        String fileName = ExcelConnectionHandler.getFilePath(url);
        this.excelFile = new File(fileName);
        if (!this.excelFile.exists()) {
            throw new IllegalArgumentException(JdbcPlugin.Util.getString("ExcelConnecton.FileNotFound", (Object)fileName));
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (methodName.equals("getMetaData")) {
            return (DatabaseMetaData)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$DatabaseMetaData == null ? (class$java$sql$DatabaseMetaData = ExcelConnectionHandler.class$("java.sql.DatabaseMetaData")) : class$java$sql$DatabaseMetaData}, (InvocationHandler)new ExcelDatabaseMetaDataHandler(this.connection.getMetaData(), this.excelFile));
        }
        return method.invoke((Object)this.connection, args);
    }

    protected static String getFilePath(String url) {
        int endIndex;
        String upperCaseUrl = url.toUpperCase();
        int startIndex = upperCaseUrl.indexOf("DBQ");
        if (startIndex == -1) {
            throw new IllegalArgumentException(JdbcPlugin.Util.getString("ExcelConnecton.invalidUrl", (Object)url));
        }
        if ((startIndex = url.indexOf("=", startIndex)) == -1) {
            throw new IllegalArgumentException(JdbcPlugin.Util.getString("ExcelConnecton.invalidUrl", (Object)url));
        }
        if ((endIndex = url.indexOf(";", ++startIndex)) == -1) {
            endIndex = url.indexOf("\"", startIndex);
        }
        if (endIndex == -1) {
            return url.substring(startIndex);
        }
        return url.substring(startIndex, endIndex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

