/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.sdt.types;

import com.metamatrix.internal.core.index.Index;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.internal.core.index.ModelIndexer;
import com.metamatrix.modeler.internal.core.index.ResourceFileIndexSelector;
import com.metamatrix.modeler.sdt.ModelerSdtPlugin;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;

public class RebuildingBuiltInTypesIndexSelector
extends ResourceFileIndexSelector {
    public static final String DATATYPES_ZIP_FILE_NAME = "builtInDatatypes.zip";
    public static final String DATATYPES_MODEL_FILE_NAME = "builtInDataTypes.xsd";
    public static final String DATATYPES_INDEX_FILE_NAME = "builtInDataTypes.INDEX";
    private static IPath DATA_DIRECTORY_PATH = null;
    private static IPath INDEX_FILE_PATH = null;

    public RebuildingBuiltInTypesIndexSelector() throws CoreException {
        super(RebuildingBuiltInTypesIndexSelector.getZipFilePath());
        RebuildingBuiltInTypesIndexSelector.removeExistingIndexFile(INDEX_FILE_PATH.toFile());
        super.setIndexDirectoryPath(DATA_DIRECTORY_PATH.toOSString());
    }

    public RebuildingBuiltInTypesIndexSelector(String filePath) throws CoreException {
        super(filePath);
        RebuildingBuiltInTypesIndexSelector.removeExistingIndexFile(INDEX_FILE_PATH.toFile());
        super.setIndexDirectoryPath(DATA_DIRECTORY_PATH.toOSString());
    }

    public Index[] getIndexes() throws IOException {
        if (!INDEX_FILE_PATH.toFile().exists()) {
            this.indexes = null;
        }
        return super.getIndexes();
    }

    protected Container createContainer(String name) throws CoreException {
        Container container = ModelerCore.createEmptyContainer((String)name);
        ModelerCore.addExternalResourceSets((Container)container);
        return container;
    }

    protected Index[] indexResources(Resource[] models) throws CoreException, IOException {
        ModelIndexer.PRINT_INDEX_CONTENTS = true;
        Index[] newIndexes = super.indexResources(models);
        ModelIndexer.PRINT_INDEX_CONTENTS = false;
        return newIndexes;
    }

    private static String getZipFilePath() {
        File zipFile;
        URL installURL = ModelerSdtPlugin.getDefault().getDescriptor().getInstallURL();
        String zipFilePath = null;
        try {
            zipFilePath = Platform.asLocalURL((URL)new URL(installURL, DATATYPES_ZIP_FILE_NAME)).getFile();
        }
        catch (Throwable t) {
            ModelerSdtPlugin.Util.log(4, t, ModelerSdtPlugin.Util.getString("BuiltInTypesIndexSelector.Error_creating_local_URL_for_1"));
            throw new ModelerCoreRuntimeException(t.getMessage());
        }
        if (zipFilePath == null || zipFilePath.length() == 0) {
            ModelerSdtPlugin.Util.log(4, ModelerSdtPlugin.Util.getString("BuiltInTypesIndexSelector.Unable_to_create_absolute_path_to_zip_file_2"));
        }
        if (!(zipFile = new File(zipFilePath)).exists()) {
            ModelerSdtPlugin.Util.log(4, ModelerSdtPlugin.Util.getString("BuiltInTypesIndexSelector.The_file_cannot_be_found_on_the_file_system_3"));
        }
        return zipFilePath;
    }

    private static void removeExistingIndexFile(File indexFile) {
        if (indexFile.exists()) {
            indexFile.delete();
        }
    }

    static {
        try {
            DATA_DIRECTORY_PATH = ModelerSdtPlugin.getDefault().getStateLocation();
        }
        catch (Throwable e) {
            String TEMP_DIR = System.getProperty("user.dir") + "\\indexes";
            DATA_DIRECTORY_PATH = new Path(TEMP_DIR);
        }
        INDEX_FILE_PATH = DATA_DIRECTORY_PATH.append(DATATYPES_INDEX_FILE_NAME);
    }
}

