/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.sdt.types;

import com.metamatrix.modeler.core.ExternalResourceDescriptor;
import com.metamatrix.modeler.core.ExternalResourceSet;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.internal.core.ExternalResourceDescriptorImpl;
import com.metamatrix.modeler.internal.core.ExternalResourceLoader;
import com.metamatrix.modeler.internal.sdt.types.XsdExternalResourceSet;
import com.metamatrix.modeler.sdt.ModelerSdtPlugin;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.ResourceSet;

public class BuiltInTypesExternalResourceSet
implements ExternalResourceSet {
    public static final String DATATYPES_ZIP_FILE_NAME = "builtInDatatypes.zip";
    public static final String DATATYPES_MODEL_FILE_NAME = "builtInDataTypes.xsd";
    public static final String BUILTIN_DATATYPES_URI = "http://www.metamatrix.com/metamodels/SimpleDatatypes-instance";
    private static final String BUILTIN_DATATYPES_CONTAINER_NAME = "builtInDatatypesContainer";
    private Container builtInTypesContainer;

    public ResourceSet getResourceSet() {
        if (this.builtInTypesContainer == null) {
            Container container = this.createContainer(BUILTIN_DATATYPES_CONTAINER_NAME);
            this.loadContainer(container);
            this.builtInTypesContainer = container;
        }
        return this.builtInTypesContainer;
    }

    protected Container createContainer(String containerName) {
        Container container = null;
        try {
            container = ModelerCore.createEmptyContainer((String)containerName);
            XsdExternalResourceSet xsdResourceSet = new XsdExternalResourceSet();
            container.addExternalResourceSet(xsdResourceSet.getResourceSet());
        }
        catch (Throwable t) {
            ModelerSdtPlugin.Util.log(4, t, ModelerSdtPlugin.Util.getString("BuiltInTypesExternalResourceSet.Error_creating_container_for_the_resource_1", (Object)DATATYPES_MODEL_FILE_NAME));
        }
        if (container == null) {
            ModelerSdtPlugin.Util.log(4, ModelerSdtPlugin.Util.getString("BuiltInTypesExternalResourceSet.Error_creating_container_for_the_resource_2", (Object)DATATYPES_MODEL_FILE_NAME));
        }
        return container;
    }

    protected void loadContainer(Container container) {
        if (container != null) {
            ExternalResourceDescriptor descriptor = this.getExternalResourceDescriptor();
            ExternalResourceLoader loader = new ExternalResourceLoader();
            try {
                loader.load(descriptor, container);
            }
            catch (Throwable t) {
                ModelerSdtPlugin.Util.log(4, t, ModelerSdtPlugin.Util.getString("BuiltInTypesExternalResourceSet.Error_loading_external_resource_into_the_built-in_datatypes_container_3", (Object)descriptor.getResourceName()));
            }
        }
    }

    protected ExternalResourceDescriptor getExternalResourceDescriptor() {
        ExternalResourceDescriptorImpl descriptor = new ExternalResourceDescriptorImpl();
        descriptor.setResourceName(DATATYPES_MODEL_FILE_NAME);
        descriptor.setInternalUri(BUILTIN_DATATYPES_URI);
        String resourceURL = null;
        try {
            URL installURL = ModelerSdtPlugin.getDefault().getDescriptor().getInstallURL();
            resourceURL = Platform.asLocalURL((URL)new URL(installURL, DATATYPES_ZIP_FILE_NAME)).getFile();
            if (resourceURL == null || resourceURL.length() == 0) {
                ModelerSdtPlugin.Util.log(4, ModelerSdtPlugin.Util.getString("BuiltInTypesExternalResourceSet.Unable_to_create_an_absolute_path_to_the_resource_4", (Object)DATATYPES_ZIP_FILE_NAME));
            } else {
                descriptor.setResourceUrl(resourceURL);
            }
        }
        catch (Throwable t) {
            ModelerSdtPlugin.Util.log(4, t, ModelerSdtPlugin.Util.getString("BuiltInTypesExternalResourceSet.Error_creating_local_URL_for_5", (Object)DATATYPES_ZIP_FILE_NAME));
        }
        String tempDirPath = null;
        try {
            tempDirPath = ModelerSdtPlugin.getDefault().getStateLocation().toOSString();
            if (tempDirPath == null || tempDirPath.length() == 0) {
                ModelerSdtPlugin.Util.log(4, ModelerSdtPlugin.Util.getString("BuiltInTypesExternalResourceSet.Unable_to_create_an_absolute_path_to_the_data_directory_for_resource_6", (Object)descriptor.getResourceUrl()));
            } else {
                descriptor.setTempDirectoryPath(tempDirPath);
            }
        }
        catch (Throwable t) {
            ModelerSdtPlugin.Util.log(4, ModelerSdtPlugin.Util.getString("BuiltInTypesExternalResourceSet.Error_creating_the_absolute_path_to_the_data_directory_for_resource_7", (Object)descriptor.getResourceUrl()));
        }
        return descriptor;
    }
}

