/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.sdt.types;

import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.xsd.aspects.sql.XsdSimpleTypeDefinitionAspect;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeAspect;
import com.metamatrix.modeler.core.types.DatatypeManager;
import com.metamatrix.modeler.core.types.DatatypeManagerLifecycle;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.sdt.ModelerSdtPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDVariety;

public abstract class AbstractDatatypeManager
implements DatatypeManager,
DatatypeManagerLifecycle {
    private static SqlDatatypeAspect sqlDatatypeAspect;
    private static final Comparator TYPE_NAME_COMPARATOR;
    private Container container;
    static /* synthetic */ Class class$org$eclipse$xsd$XSDSimpleTypeDefinition;

    public void initialize(Container container) throws ModelerCoreException {
        this.container = container;
        this.doInitialize();
    }

    protected abstract void doInitialize() throws ModelerCoreException;

    public Container getContainer() {
        return this.container;
    }

    protected static boolean containsUuidPattern(String id) {
        return id != null && id.indexOf("mmuuid") >= 0;
    }

    protected static String extractUuidString(String id) {
        if (AbstractDatatypeManager.containsUuidPattern(id)) {
            int beginIndex = id.indexOf("mmuuid");
            return id.substring(beginIndex);
        }
        return null;
    }

    protected static ObjectID getObjectIDFromString(String idString) throws ModelerCoreException {
        try {
            return IDGenerator.getInstance().stringToObject(idString);
        }
        catch (Throwable e) {
            throw new ModelerCoreException(e, ModelerSdtPlugin.Util.getString("DatatypeManagerImpl.Error_finding_the_EObject_with_UUID_11", (Object)idString));
        }
    }

    protected static void sortByName(List eObjs) {
        Collections.sort(eObjs, TYPE_NAME_COMPARATOR);
    }

    protected static SqlDatatypeAspect getSqlAspect(EObject obj) {
        if (obj != null && obj instanceof XSDSimpleTypeDefinition) {
            if (ModelerCore.getPlugin() == null) {
                if (sqlDatatypeAspect == null) {
                    sqlDatatypeAspect = new XsdSimpleTypeDefinitionAspect(null);
                }
                return sqlDatatypeAspect;
            }
            return (SqlDatatypeAspect)ModelerCore.getMetamodels().getMetamodelAspect(obj, "sqlAspect");
        }
        return null;
    }

    protected static void removeDuplicates(List eObjs) {
        ArrayList<EObject> tmp = new ArrayList<EObject>(eObjs.size());
        Iterator iter = eObjs.iterator();
        while (iter.hasNext()) {
            EObject eObj = (EObject)iter.next();
            if (!tmp.contains(eObj)) {
                tmp.add(eObj);
                continue;
            }
            iter.remove();
        }
    }

    protected List getDatatypeResources() throws ModelerCoreException {
        Container container = this.getContainer();
        if (container == null) {
            return Collections.EMPTY_LIST;
        }
        if (ModelerSdtPlugin.getDefault() != null && ModelerCore.isModelContainer((Container)container)) {
            ArrayList<Resource> lstResultResources = new ArrayList<Resource>();
            try {
                ModelResource[] mrResources = ModelerCore.getModelWorkspace().getModelResources();
                for (int i = 0; i < mrResources.length; ++i) {
                    Resource xsdResource;
                    ModelResource mrResource = mrResources[i];
                    IResource irResource = mrResource.getResource();
                    if (!ModelUtil.isModelFile((IResource)irResource) || !irResource.exists() || !ModelUtil.isXsdFile((IResource)irResource) || (xsdResource = mrResource.getEmfResource()) == null) continue;
                    lstResultResources.add(xsdResource);
                }
            }
            catch (CoreException ce) {
                ModelerCore.Util.log((Throwable)ce);
            }
            return lstResultResources;
        }
        EList resources = container.getResources();
        ArrayList<Resource> datatypeResources = new ArrayList<Resource>();
        Iterator iter = resources.iterator();
        while (iter.hasNext()) {
            Resource resource = (Resource)iter.next();
            if (!ModelUtil.isXsdFile((Resource)resource)) continue;
            datatypeResources.add(resource);
        }
        return datatypeResources;
    }

    public EObject[] getTypeHierarchy(EObject type) {
        ArgCheck.isInstanceOf((Class)(class$org$eclipse$xsd$XSDSimpleTypeDefinition == null ? (class$org$eclipse$xsd$XSDSimpleTypeDefinition = AbstractDatatypeManager.class$("org.eclipse.xsd.XSDSimpleTypeDefinition")) : class$org$eclipse$xsd$XSDSimpleTypeDefinition), (Object)type);
        if (((XSDSimpleTypeDefinition)type).getVariety() != XSDVariety.ATOMIC_LITERAL) {
            return new EObject[]{type};
        }
        ArrayList<EObject> tmp = new ArrayList<EObject>();
        tmp.add(type);
        try {
            EObject baseType;
            EObject simpleType = type;
            while (simpleType != this.getAnySimpleType() && (baseType = this.getBaseType(simpleType)) != null && baseType != this.getAnyType() && simpleType != baseType) {
                tmp.add(baseType);
                simpleType = baseType;
            }
        }
        catch (ModelerCoreException e) {
            ModelerSdtPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
        return tmp.toArray(new EObject[tmp.size()]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TYPE_NAME_COMPARATOR = new DatatypeNameComparator();
    }

    protected static class DatatypeNameComparator
    implements Comparator {
        protected DatatypeNameComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            if (obj1 == null && obj2 == null) {
                return 0;
            }
            if (obj1 == null && obj2 != null) {
                return -1;
            }
            if (obj1 != null && obj2 == null) {
                return 1;
            }
            XSDTypeDefinition dt1 = (XSDTypeDefinition)obj1;
            XSDTypeDefinition dt2 = (XSDTypeDefinition)obj2;
            String value1 = dt1.getName();
            String value2 = dt2.getName();
            return value1.compareToIgnoreCase(value2);
        }
    }
}

