/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.mapping.factory;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.mapping.DebugConstants;
import com.metamatrix.modeler.mapping.PluginConstants;
import com.metamatrix.modeler.mapping.factory.ITreeToRelationalMapper;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelMapperFactory
implements DebugConstants,
PluginConstants,
PluginConstants.ExtensionPoints.ModelMapper {
    private static final Class CLASS = class$com$metamatrix$modeler$internal$mapping$factory$ModelMapperFactory == null ? (class$com$metamatrix$modeler$internal$mapping$factory$ModelMapperFactory = ModelMapperFactory.class$("com.metamatrix.modeler.internal.mapping.factory.ModelMapperFactory")) : class$com$metamatrix$modeler$internal$mapping$factory$ModelMapperFactory;
    private static final String PREFIX = I18nUtil.getPropertyPrefix((Class)CLASS);
    private static Map uriConfigElementMap;
    private static Map uriMapperMap;
    static /* synthetic */ Class class$com$metamatrix$modeler$internal$mapping$factory$ModelMapperFactory;

    private ModelMapperFactory() {
    }

    private static void buildMapperMaps() {
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printEntered(CLASS, "buildMapperMap()");
        }
        uriConfigElementMap = new HashMap();
        uriMapperMap = new HashMap();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.metamatrix.modeler.mapping", "modelMapper");
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions.length > 0) {
            for (int i = 0; i < extensions.length; ++i) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                Object extension = null;
                String metamodelUri = null;
                if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
                    PluginConstants.Util.print(CLASS, "buildMapperMap():found " + elements.length + " mapper extensions");
                }
                for (int j = 0; j < elements.length; ++j) {
                    try {
                        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
                            PluginConstants.Util.print(CLASS, "buildMapperMap():processing " + elements[j].getAttribute("name"));
                        }
                        if ((extension = elements[j].createExecutableExtension("name")) instanceof ITreeToRelationalMapper) {
                            metamodelUri = elements[j].getAttribute("metamodelUri");
                            if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
                                PluginConstants.Util.print(CLASS, "buildMapperMap():model URI=<" + metamodelUri + ">.");
                            }
                            if (metamodelUri != null && metamodelUri.length() > 0) {
                                uriMapperMap.put(metamodelUri, extension);
                                uriConfigElementMap.put(metamodelUri, elements[j]);
                                continue;
                            }
                            PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "invalidModelId", new Object[]{extension.getClass().getName()}));
                            continue;
                        }
                        PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "invalidMapperClass", new Object[]{extension.getClass().getName()}));
                        continue;
                    }
                    catch (Exception theException) {
                        PluginConstants.Util.log(4, (Throwable)theException, PluginConstants.Util.getString(PREFIX + "loadingMapperProblem", new Object[]{elements[j].getAttribute("name")}));
                    }
                }
            }
        }
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printExited(CLASS, "buildMapperMap():uriConfigElementMap=" + uriConfigElementMap);
        }
    }

    public static ITreeToRelationalMapper createModelMapper(String theMetamodelUri) {
        IConfigurationElement configElement;
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printEntered(CLASS, "createModelMapper(String):theMetamodelUri=" + theMetamodelUri);
        }
        ArgCheck.isNotNull((Object)theMetamodelUri);
        ArgCheck.isNotEmpty((String)theMetamodelUri);
        ITreeToRelationalMapper result = null;
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.print(CLASS, "createModelMapper(String):model URI=" + theMetamodelUri + ", IConfigurationElement=" + uriConfigElementMap.get(theMetamodelUri));
        }
        if ((configElement = (IConfigurationElement)uriConfigElementMap.get(theMetamodelUri)) != null) {
            try {
                result = (ITreeToRelationalMapper)configElement.createExecutableExtension("name");
            }
            catch (CoreException theException) {
                PluginConstants.Util.log(4, PluginConstants.Util.getString(PREFIX + "createMapperProblem", new Object[]{theMetamodelUri, configElement.getAttribute("name")}));
            }
        }
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printExited(CLASS, "createModelMapper(String):mapper=" + result);
        }
        return result;
    }

    public static ITreeToRelationalMapper createModelMapper(EObject theTreeNode) {
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printEntered(CLASS, "createModelMapper(EObject):theTreeNode=" + theTreeNode);
        }
        ArgCheck.isNotNull((Object)theTreeNode);
        ITreeToRelationalMapper result = null;
        String uri = ModelMapperFactory.getMetamodelUri(theTreeNode);
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.print(CLASS, "createModelMapper(EObject):metamodelUri=" + uri);
        }
        if (uri != null) {
            result = ModelMapperFactory.createModelMapper(uri);
        }
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printExited(CLASS, "createModelMapper(EObject):mapper=" + result);
        }
        result.setTreeRoot(theTreeNode);
        return result;
    }

    private static String getMetamodelUri(EObject theTreeNode) {
        ModelAnnotation annot;
        Resource eResource;
        ArgCheck.isNotNull((Object)theTreeNode);
        Container container = ModelerCore.getContainer((EObject)theTreeNode);
        if (container == null) {
            try {
                container = ModelerCore.getModelContainer();
            }
            catch (CoreException err) {
                ModelerCore.Util.log((Throwable)err);
            }
        }
        if ((eResource = ModelerCore.getModelEditor().findResource(container, theTreeNode)) instanceof EmfResource && (annot = ((EmfResource)eResource).getModelAnnotation()) != null && annot.getPrimaryMetamodelUri() != null) {
            return annot.getPrimaryMetamodelUri();
        }
        return null;
    }

    public static boolean isTreeRoot(EObject theTreeNode) {
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printEntered(CLASS, "isTreeRoot(EObject):theTreeNode=" + theTreeNode);
        }
        ArgCheck.isNotNull((Object)theTreeNode);
        boolean result = false;
        String uri = ModelMapperFactory.getMetamodelUri(theTreeNode);
        if (uri != null) {
            ITreeToRelationalMapper mapper = (ITreeToRelationalMapper)uriMapperMap.get(uri);
            if (mapper == null) {
                if (!uriMapperMap.containsKey(uri)) {
                    uriMapperMap.put(uri, null);
                }
            } else {
                result = mapper.isTreeRoot(theTreeNode);
            }
            if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
                PluginConstants.Util.printExited(CLASS, "isTreeRoot(EObject):result=" + result + ", metamodel URI=" + uri);
            }
        }
        return result;
    }

    public static boolean isXmlTreeNode(EObject theTreeNode) {
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printEntered(CLASS, "isTreeRoot(EObject):theTreeNode=" + theTreeNode);
        }
        ArgCheck.isNotNull((Object)theTreeNode);
        boolean result = false;
        String uri = theTreeNode.eClass().getEPackage().getNsURI();
        ITreeToRelationalMapper mapper = (ITreeToRelationalMapper)uriMapperMap.get(uri);
        if (mapper != null) {
            result = mapper.isTreeNode(theTreeNode);
        }
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printExited(CLASS, "isTreeRoot(EObject):result=" + result + ", metamodel URI=" + uri);
        }
        return result;
    }

    public static EObject getTreeRoot(EObject someTreeNode) {
        EObject treeRoot = null;
        if (ModelMapperFactory.isTreeRoot(someTreeNode)) {
            treeRoot = someTreeNode;
        } else if (someTreeNode.eContainer() != null) {
            EObject parent = someTreeNode.eContainer();
            boolean failure = false;
            while (treeRoot == null && !failure) {
                if (ModelMapperFactory.isTreeRoot(parent)) {
                    treeRoot = parent;
                    continue;
                }
                if (parent.eContainer() != null) {
                    parent = parent.eContainer();
                    continue;
                }
                failure = true;
            }
        }
        return treeRoot;
    }

    public static EObject getXsdComponent(EObject theTreeNode) {
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printEntered(CLASS, "getXsdComponent(EObject):theTreeNode=" + theTreeNode);
        }
        ArgCheck.isNotNull((Object)theTreeNode);
        EObject result = null;
        String uri = theTreeNode.eClass().getEPackage().getNsURI();
        ITreeToRelationalMapper mapper = (ITreeToRelationalMapper)uriMapperMap.get(uri);
        if (mapper != null) {
            result = mapper.getXsdComponent(theTreeNode);
        }
        if (PluginConstants.Util.isDebugEnabled("modelMapper")) {
            PluginConstants.Util.printExited(CLASS, "getXsdComponent(EObject):result=" + result + ", metamodel URI=" + uri);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ModelMapperFactory.buildMapperMaps();
    }
}

