/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.mapping.factory;

import com.metamatrix.metamodels.transformation.MappingClass;
import com.metamatrix.modeler.internal.mapping.factory.MappingClassFactory;
import com.metamatrix.modeler.internal.mapping.factory.MappingClassGenerationVisitor;
import com.metamatrix.modeler.internal.mapping.factory.TreeMappingAdapter;
import com.metamatrix.modeler.mapping.factory.ITreeToRelationalMapper;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class MappingClassSplitterVisitor
extends MappingClassGenerationVisitor {
    private MappingClass mappingClassToSplit;
    private TreeMappingAdapter mapping;
    private List mappingClassList;
    private Map mappingClassLocationMap;

    public MappingClassSplitterVisitor(MappingClass mappingClassToSplit, TreeMappingAdapter mapping, ITreeToRelationalMapper mapper, MappingClassFactory factory, Map mappingClassAttributeMap) {
        super(mapper, factory, mappingClassAttributeMap, false, false, new HashSet());
        this.mappingClassToSplit = mappingClassToSplit;
        this.mapping = mapping;
        this.mappingClassList = mapping.getAllMappingClasses();
        this.generateMappingClassLocationMap();
    }

    public boolean visit(EObject node) {
        if (this.attributeMap.containsKey(node)) {
            if (this.mappingClassLocationMap.containsKey(node)) {
                this.markNextMappingClassRecursive = false;
            } else {
                if (this.mapper.isRecursive(node)) {
                    this.markNextMappingClassRecursive = true;
                }
                MappingClass mappingClass = this.factory.createMappingClass(node, true, this.markNextMappingClassRecursive);
                this.markNextMappingClassRecursive = false;
                this.mapping.removeLocation(this.mappingClassToSplit, node);
                HashMap nameAttributeMap = new HashMap();
                this.factory.moveOrCreateMappingAttributes(mappingClass, (Collection)this.attributeMap.get(node), nameAttributeMap, false, this.datatypeAccumulator);
            }
        } else if (this.mapper.isRecursive(node)) {
            this.markNextMappingClassRecursive = true;
        }
        return true;
    }

    private void generateMappingClassLocationMap() {
        this.mappingClassLocationMap = new HashMap();
        Iterator iter = this.mappingClassList.iterator();
        while (iter.hasNext()) {
            MappingClass mappingClass = (MappingClass)iter.next();
            Iterator locationIter = this.mapping.getLocations(mappingClass).iterator();
            while (locationIter.hasNext()) {
                EObject documentLocation = (EObject)locationIter.next();
                if (documentLocation == null) continue;
                this.mappingClassLocationMap.put(documentLocation, mappingClass);
            }
        }
    }
}

