/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.jdbc.relational;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.internal.jdbc.relational.ModelerJdbcRelationalConstants;
import com.metamatrix.modeler.internal.jdbc.relational.util.JdbcRelationalUtil;
import com.metamatrix.modeler.jdbc.JdbcException;
import com.metamatrix.modeler.jdbc.JdbcImportSettings;
import com.metamatrix.modeler.jdbc.JdbcManager;
import com.metamatrix.modeler.jdbc.JdbcPlugin;
import com.metamatrix.modeler.jdbc.JdbcSource;
import com.metamatrix.modeler.jdbc.metadata.Includes;
import com.metamatrix.modeler.jdbc.metadata.JdbcDatabase;
import com.metamatrix.modeler.jdbc.metadata.JdbcNode;
import com.metamatrix.modeler.jdbc.relational.JdbcRelationalPlugin;
import com.metamatrix.modeler.jdbc.relational.RelationalModelProcessor;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public final class JdbcImporter
implements ModelerJdbcRelationalConstants {
    private ModelResource updatedModel;
    private JdbcSource src;
    private JdbcDatabase db;

    public JdbcDatabase getDatabase() {
        return this.db;
    }

    public JdbcSource getSource() {
        return this.src;
    }

    public ModelResource getUpdatedModel() {
        return this.updatedModel;
    }

    public void setDatabase(JdbcDatabase database) {
        this.db = database;
    }

    public void setSource(JdbcSource source) {
        ArgCheck.isNotNull((Object)source);
        this.src = source;
    }

    public void setUpdatedModel(ModelResource model) throws ModelWorkspaceException {
        this.updatedModel = null;
        if (model != null) {
            Iterator modelIter = model.getAllRootEObjects().iterator();
            while (modelIter.hasNext()) {
                Object obj = modelIter.next();
                if (!(obj instanceof JdbcSource)) continue;
                this.updatedModel = model;
                try {
                    this.src = (JdbcSource)ModelerCore.getModelEditor().copy((EObject)((JdbcSource)obj));
                    this.setUpdatedModelSettings();
                    break;
                }
                catch (Exception err) {
                    throw new ModelWorkspaceException((Throwable)err);
                }
            }
        }
    }

    public void setUpdatedModelSettings() throws JdbcException {
        if (this.db == null) {
            return;
        }
        JdbcImportSettings settings = this.src.getImportSettings();
        if (settings != null) {
            Iterator objIter = settings.getExcludedObjectPaths().iterator();
            while (objIter.hasNext()) {
                Path path = new Path((String)objIter.next());
                JdbcNode node = this.findNode((IPath)path, this.db);
                if (node == null) continue;
                node.setSelected(false);
            }
            Includes includes = this.db.getIncludes();
            EList types = settings.getIncludedTableTypes();
            includes.setIncludedTableTypes(types.toArray(new String[types.size()]));
            includes.setApproximateIndexes(settings.isIncludeApproximateIndexes());
            includes.setIncludeForeignKeys(settings.isIncludeForeignKeys());
            includes.setIncludeIndexes(settings.isIncludeIndexes());
            includes.setIncludeProcedures(settings.isIncludeProcedures());
            includes.setUniqueIndexesOnly(settings.isIncludeUniqueIndexes());
        }
    }

    public void connect(String password, IProgressMonitor monitor) throws CoreException, IOException, SQLException {
        this.disconnect();
        JdbcManager mgr = JdbcRelationalUtil.getJdbcManager();
        Connection connection = mgr.createConnection(this.src, null, password, monitor);
        this.db = JdbcPlugin.getJdbcDatabase(this.src, connection);
    }

    public void connect(String password) throws CoreException, IOException, SQLException {
        this.connect(password, null);
    }

    public void disconnect() throws SQLException {
        Connection connection;
        if (this.db != null && (connection = this.db.getConnection()) != null) {
            connection.close();
        }
    }

    public JdbcNode findNode(IPath path, JdbcNode parent) throws JdbcException {
        String seg = path.segment(0);
        JdbcNode[] children = parent.getChildren();
        int ndx = children.length;
        while (--ndx >= 0) {
            JdbcNode child = children[ndx];
            if (!seg.equalsIgnoreCase(child.getName())) continue;
            if (path.segmentCount() > 1) {
                return this.findNode(path.removeFirstSegments(1), child);
            }
            return child;
        }
        return null;
    }

    public IStatus importModel() throws ModelWorkspaceException {
        return this.importModel(null);
    }

    public IStatus importModel(IProgressMonitor monitor) throws ModelWorkspaceException {
        RelationalModelProcessor processor = JdbcRelationalPlugin.createRelationalModelProcessor(this.src);
        IStatus status = processor.execute(this.updatedModel, this.db, this.src.getImportSettings(), monitor);
        return status;
    }
}

